#!/bin/sh
echo "Press enter to update the repmgr-template.conf & pg_hba-template.conf files"
echo "Updating repmgr-template.conf"
echo "===================="

read -p "Enter node id for repmgr configuration Ex: node_1:  " nodeid
read -p "Enter current node private hostname Ex: ip-172-21-2-31.ec2.internal:  " nodehostname
read -p "Enter the current node ip Ex:172.21.1.31:  " nodeip

cp -f repmgr-template.conf /tmp/repmgr-template.conf
cp -f pg_hba-template.conf /tmp/pg_hba-template.conf

sed -i "s/##NODE_ID##/$nodeid/g" /tmp/repmgr-template.conf
sed -i "s/##HOSTNAME##/$nodehostname/g" /tmp/repmgr-template.conf
sed -i "s/##HOST_IP##/$nodeip/g" /tmp/repmgr-template.conf

echo

echo "Updating pg_hba-template.conf"
read -p "Enter primary node ip Ex: 172.21.1.31  " primaryip
read -p "Enter secondary node ip Ex: 172.21.1.32  " secondaryip

sed -i "s/##PRIMARY_IP##/$primaryip/g" /tmp/pg_hba-template.conf
sed -i "s/##SECONDARY_IP##/$secondaryip/g" /tmp/pg_hba-template.conf

cp -f /tmp/repmgr-template.conf /opt/pixelperfect/pgsql/repmgr.conf
cp -f /tmp/pg_hba-template.conf /opt/pixelperfect/pgsql/data/pg_hba.conf

echo "Changing all file permissions to ppradmin:ppradmin"
chmod 755 /opt/pixelperfect/pgsql/bin/repmgr
chmod 755 /opt/pixelperfect/pgsql/bin/repmgrd

chown -R ppradmin:ppradmin /opt/pixelperfect/pgsql

echo "Stopping and Starting posrtgres service"
systemctl stop postgresql_ppr.service
systemctl start postgresql_ppr.service

currentIPAddress=`hostname -I`
echo "Current Machine IP Address: $currentIPAddress"
if [ $currentIPAddress = $primaryip ]
then
	echo "Creating primary standy register"
        registeroutput=`su -l ppradmin -c "/opt/pixelperfect/pgsql/bin/repmgr -f /opt/pixelperfect/pgsql/repmgr.conf primary register"`
        echo $registeroutput

fi

if [ $currentIPAddress = $secondaryip ]
then
	systemctl stop postgresql_ppr.service
	echo "Creating secondary standy clone"
	cloneoutput=`su -l ppradmin -c "/opt/pixelperfect/pgsql/bin/repmgr -h $primaryip -U repmgr -p 8032 -d repmgr -F -f /opt/pixelperfect/pgsql/repmgr.conf standby clone"`
	systemctl start postgresql_ppr.service
	sleep 10
	echo $cloneoutput
	echo "Creating secondary standby register"
	registeroutput=`su -l ppradmin -c "/opt/pixelperfect/pgsql/bin/repmgr -f /opt/pixelperfect/pgsql/repmgr.conf standby register"`
	echo $registeroutput
	echo "Show the cluster"
	clusteroutput=`su -l ppradmin -c "/opt/pixelperfect/pgsql/bin/repmgr -f /opt/pixelperfect/pgsql/repmgr.conf cluster show"`
	echo $clusteroutput
fi
