/* TABE Pixel Perfect Extension */

// Wrap everything in an anonymous function to avoid polluting the global namespace; 
(function () {
	// eslint-disable-next-line no-undef
	const extensions = tableau.extensions;

	//Initialize Global Variables
	let tableauBaseUrl = "";
	const excludedFilters = new Set(['Measure Names', 'HFI', 'SFO', 'DB RequestStatus']);
	console.log('Referrer: ', document.referrer);
	setCookie("TESTALB","123456","1");
	let tableauWorkBook = "";
	let siteName = "";
	let match;
	try {
		const referrer = document.referrer;
		let reg = /(http:\/\/.*?\/|https:\/\/.*?\/)(.*)(\/)?(views|authoring)(\/)(.*)\/.*/;
		match = reg.exec(referrer);
		if (match) {
			if (match[1]) {
				tableauBaseUrl = match[1];
			}
			if (match[2]) {
				if (match[2][match[2].length - 1] === "/") {
					match[2] = match[2].slice(0, -1);
				}
				siteName = match[2].split("/").pop();
			}
			if (match[6]) {
				tableauWorkBook = match[6];
			}
		}
	} catch (e) {
		console.log("Failed to parse workbook URL", e);
	}

	console.log("Tableau URL, Site, Workbook: ", match, tableauBaseUrl, siteName, tableauWorkBook);

	// To get filter info, first get the dashboard.
	let dashboard;

	let ReportNames = [];
	let UserName = "";
	let sampleData = "";
	let reportingUrl = "";
	let reportingApplication = "";
	let authentication = "";
	let paramData = "";
	let paramDataString = "";
	let dataSourceSheet = "";
	let ImageSourceSheet = "";
	//let urlBase =  "http://localhost:9097/pps/downloadReport";
	//let urlBase =  "http://localhost:9099/v1/downloadReport";
	let urlBase = window.Configs.host + "/pps/downloadReport";
	let urlString = "";
	let outputFormat = "";//paramData[0];
	let reportName = "";//paramData[1];
	const apiVersion = '3.4';
	let viewMap = [];
	let isSummaryData = true;
	let dynamicCsvOutputDelimiter = ",";
	let sessionToken = "";
	let isIeBrowser = false;
	let tableauDataTranspose = false;
	let selectedColumns = [];
	let selectedFilters = new Set();
	let allParams = [];
	let parameterObjMap = {};
	let selectedParameters = new Set();
	let isTableauConfigured = false;
	let filtersPresentInDashboard = [];
	let dataSourceSheetContentUrlList = "";
	let imageSourceSheetContentUrl = "";
	let arrWorkbookContentUrl = [];
	let parametersPresentInDashboard = [];
	let customReportName = "";
	let enableTimeStamp = false;
	let dateFormat = "yyyyMMdd";
	let generateTxtEnabled;
	let encapsulateDataEnabled;
	// multiReport & multiReportData belongs to Multiple Report Feature
	let multiReport = false;
	let multiReportData = null;

	/* -> enableFilterBy -- flag (Bool)
	   this flag will be switched based on check-server api response filter by property
	   if true means Filter By feature should be enabled in webfolio
	   and vice-verse.
	   
	   -> pprFilterSheetName -- Name of worksheet (String)
	   Name of the worksheet that contains the filter names and
	   their options.
	   
	   -> filterByData -- payload to webfolio (object)
	   It is the purest object which contains value, encodededvalue and name of a filter
	   it is sent to webfolio for UI population.
	*/
	let enableFilterBy = false;
	let pprFilterSheetName = "PPR_CUSTOM";
	let filterByData = {};
	/* shouldFilterPresentOnDashboard should be false
	 * because if it is truned true it will cause issues with dashboard
	 * if PPR_CUSTOM has Filter which is not present on dashboard as filter
	 * logic fails to Detect PPR_CUSTOM sheet itself due to exception  
	*/
	let shouldFilterPresentOnDashboard = false;

	// eslint-disable-next-line no-undef
	urlString = $.validator.format("{0}?ReportName={1}&OutputFormat={2}&workbook={3}&c=x", [urlBase, reportName, outputFormat, tableauWorkBook]);


	// eslint-disable-next-line no-undef
	$(document).ready(function () {
		/**
		When initializing an extension, an optional object is passed that maps a special ID (which
		must be 'configure') to a function.  This, in conjuction with adding the correct context menu
		item to the manifest, will add a new "Configure..." context menu item to the zone of extension
		inside a dashboard.  When that context menu item is clicked by the user, the function passed
		here will be executed.
		*/
		const inactiveElement = document.getElementById('inactive');

		extensions.initializeAsync({ 'configure': configure }).then(function () {

			let tableauEnvironment = tableau.extensions.environment.context;
			console.log("tableauEnvironment", tableauEnvironment);


			httpRequest(`${window.Configs.host}/pps/config/check-server?server=${encodeURIComponent(tableauBaseUrl)}`).then(function (response) {
				if (tableauEnvironment == "desktop") {
					return true;
				} else {
					return response.json()
				}
			}).then(function (checkServerRes) {
				isTableauConfigured = checkServerRes.valid;
				enableFilterBy = checkServerRes.filterBy || true;
				console.log("Tableau Configuration Status", isTableauConfigured);
				if (isTableauConfigured) {
					dashboard = extensions.dashboardContent.dashboard;

					//  Get all filter list applied on dashboard
					let dashboardObject = dashboard.objects;

					dashboardObject.forEach(function (item) {
						if (item.type == "quick-filter") {
							filtersPresentInDashboard.push(item.name);
						}
						if (item.type == "parameter-control") {
							parametersPresentInDashboard.push(item.name);
						}
					});

					/* 
						Below Condition decides to get Filter name and values
						from ppr custom sheet "PPR_CUSTOM" based on the flag
						configured in admin Console.
					 */
					if (enableFilterBy === true) {
						extractFilterDetails(dashboard);
					}

					// First, check for any saved settings and populate our UI based on them.
					let con = extensions.settings.getAll();
					console.log("Saved Settings", con);
					dashboard.worksheets.forEach(function (worksheet) {
						worksheet.addEventListener(tableau.TableauEventType.FilterChanged, function (event) {
							event.getFilterAsync().then(function (newValue) {
								selectedFilters.add(newValue.fieldName);
							});
						});
					});
					dashboard.getParametersAsync().then(function (allParameters) {
						allParams = allParameters;
						console.log('All Parameters: ', allParams);
						parameterObjMap = allParams.reduce(function (res, param) { return Object.assign(res, { [param.name]: transformParam(param) }) }, {});
						allParams.forEach(function (param) {
							param.addEventListener(tableau.TableauEventType.ParameterChanged, function (event) {
								event.getParameterAsync().then(function (newValue) {
									selectedParameters.add(newValue.name);
									parameterObjMap[param.name] = transformParam(newValue);
								});
							});
						});
						UserName = getUsername(allParams);
						if (UserName === null) {
							console.log('No parameter named pix Username found, trying to find username from sheet data');
							getUsernameUsingSheetData().then(function (res) {
								checkForSettings(con);
							}).catch(function (error) {
								console.log('Error getting username from sheet data');
							});
						} else {
							console.log('Found username from parameter', UserName);
							checkForSettings(con);
						}
					}).catch(function (err) {
						console.log('No parameter named pix Username found, trying to find username from sheet data');
						getUsernameUsingSheetData().then(function (res) {
							checkForSettings(con);
						}).catch(function (error) {
							console.log('Error getting username from sheet data');
						});
					});
				} else {
					inactiveElement.textContent = 'Tableau Server not configured, Please contact Admin';
					displaySnackBar({ message: 'Tableau Server not configured, Please contact Admin', duration: 4000 });
				}
			}).catch(function (err) {
				console.log('Error checking for Tableau server configuration status');
			});
			// }).catch(function(error){
			// console.log('Error reading settings: ', error);
			// });
		}, function (err) {
			// Something went wrong in initialization
			console.log('Error while Initializing: ' + err.toString());
		})
			.then(function () {
				// This event allows for the parent extension and popup extension to keep their
				// settings in sync.  This event will be triggered any time a setting is
				// changed for this extension, in the parent or popup (i.e. when settings.saveAsync is called).
				extensions.settings.addEventListener(
					// eslint-disable-next-line no-undef
					tableau.TableauEventType.SettingsChanged,
					function (settingsEvent) {
						checkForSettings(settingsEvent.newSettings);
					}
				);
			});
		document.getElementById("ReportButton").addEventListener('click', getDataAndSubmitForm); //onClick function
	});

	/* function - convertFilterValuesMapToAppliedValuesArr
	* converting the map to array
	* deleting the map after extracting filter options
	 */
	function convertFilterValuesMapToAppliedValuesArr(_filter) {
		_filter.valuesMap.forEach((value, key) => {
			let optObj = {};
			optObj["value"] = value;
			optObj["formattedValue"] = key;

			_filter["appliedValues"].push(optObj);
		});
		delete _filter.valuesMap;
	}

	/* function - getFilterValuesEncoded_FBy
	   * Converts formatted value of filter option to encodedvalue
	   * encoded value is suitable to pass the filter values via url parameter 
	 */

	function getFilterValuesEncoded_FBy(filter, encode) {

		switch (filter.filterType) {
			case 'categorical':
				filter.appliedValues.forEach(function (value) {
					let filterValue = value.formattedValue;
					if (encode) {
						if (Object.prototype.toString.call(value.value) === '[object Date]') {
							filterValue = encodeAndEscape(getFormattedDate(value.value));
						} else if (value.value === '%null%') {
							filterValue = '~~null~';
						} else if (value.formattedValue === 'Null' && (value.value === undefined || isNaN(value.value))) {
							filterValue = '~~null~';
						} else if (value.formattedValue === 'Null' && value.value === true) { // condition for Boolean Filters, always return true for Null, True and False values.
							filterValue = '~~null~';
						} else if (value.formattedValue === 'False' && value.value === true) {  // condition for Boolean Filters, always return true for Null, True and False values.
							filterValue = 'false';
						} else if (value.value === null) {
							filterValue = '';
						} else {
							filterValue = encodeAndEscape(value.value);
						}
						value["encodedValue"] = filterValue;
					} else {
						value["encodedValue"] = filterValue;
					}

				});
				break;
			default:
		}
	}

	function showMissingFilterMsg(msg) {
		return;
		let dispElement = document.getElementById('inactive');
		let preTxt = dispElement.innerText;
		dispElement.innerHTML = '<b style="color:red; font-weight:bold;">' + msg + '</b><br />' + preTxt;
	}

	/* function  -- extractFilterDetails
	  * Get summery data from PPR_CUSTOM
	  * Extract usefull info like Filter name and filter values
	  * package it into well formatted shiny object
	  * prepare to send to webfolio
	 */
	function extractFilterDetails(dashboard) {

		let FILTERS = {}; // Main object that will have complete filter details
		// set of flag keep tracks if sheet, filter names and values are present on sheet
		let hasPprFilter = { sheet: false, names: false, values: false };

		dashboard.worksheets.forEach(function (worksheet, ws_index, ws_arr) {
			if (worksheet.name == pprFilterSheetName) {
				hasPprFilter.sheet = true;

				worksheet.getSummaryDataAsync().then(function (sumdata) {
					let data = sumdata;

					/* Below if condition
				    * iterating through each column headers in summery data
					* Extracting column headers which is our filter names (fieldName)
					* Creating props like datatype = data type of the column
					* appliedValue - array that will contain unique filter options and their encoded value
					* valuesMap - multiple common values can be received from summery data for a column
								  hence to maintain unique values.
					* Finally adding all these details to FILTERS obj
					* In order to quickly access FILTERS obj, properties will be F_<Index ID> of the column
					 */
					if (Array.isArray(data.columns) && data.columns.length > 0) {
						hasPprFilter.names = true;
						data.columns.forEach(clmn => {
							let _shouldPresent = shouldFilterPresentOnDashboard;
							let _isPresent = filtersPresentInDashboard.includes(clmn.fieldName);
							let _acknowledgeFilter = ((_shouldPresent && _isPresent) || !_shouldPresent);

							if (_acknowledgeFilter) {
								let filterObj = {};
								filterObj['dataType'] = clmn.dataType;
								filterObj['fieldName'] = clmn.fieldName;
								filterObj['index'] = clmn.index;
								filterObj["filterType"] = 'categorical';
								filterObj["appliedValues"] = [];
								filterObj["valuesMap"] = new Map();

								FILTERS[`F_${clmn.index}`] = filterObj;
							}
						})
					} else {
						// No data in PPR_CUSTOM
					}

					/* Below if condtion - iterated over data (rows of the summery datat)
					   * data.data is an array determines row in a table data, each row also contains array of object,
						 each object represents a cell.
					   * row.forEach -- iterating through each cell
					   * each cell have index (c_index) that is same as column index of the headers
					   * Putting values to valuesMap to get unique values for each filter value 
					 */
					if (Array.isArray(data.data) && data.data.length > 0) {
						hasPprFilter.values = true;

						data.data.forEach((row, r_index) => {
							row.forEach((cell, c_index) => {
								let _value, _formattedValue;

								if (FILTERS[`F_${c_index}`].dataType == 'int' || FILTERS[`F_${c_index}`].dataType == 'float') {
									_formattedValue = cell.formattedValue.replace(/,/g, '');
								} else {
									_formattedValue = cell.formattedValue;
								}
								_value = cell.value;

								FILTERS[`F_${c_index}`].valuesMap.set(_formattedValue, _value);
							});
						});
					} else {
						// No data in PPR_CUSTOM
					}
					/* * Now we have filter names and its unique values
					   * we need to convert the formatted values to encoded values 
					 */
					for (var fName in FILTERS) {
						convertFilterValuesMapToAppliedValuesArr(FILTERS[fName]);
						getFilterValuesEncoded_FBy(FILTERS[fName], true);
					}
				}).then(() => {

					filterByData["FILTERS"] = FILTERS;
					filterByData["hasPprFilter"] = hasPprFilter;
					if (hasPprFilter.sheet === false) {
						// PPR_CUSTOM not available
						let _msg = 'Missing "PPR_CUSTOM worksheet" !!';
						showMissingFilterMsg(_msg);
					} else if (hasPprFilter.names === false) {
						// No headers in PPR_FILTERS SHEET which means no data
						let _msg = 'Missing Columns in "PPR_CUSTOM worksheet" !!';
						showMissingFilterMsg(_msg);
					} else if (hasPprFilter.values === false) {
						// No data in PPR_FILTERS SHEET 
						let _msg = 'Missing row data in "PPR_CUSTOM worksheet" !!';
						showMissingFilterMsg(_msg);
					}
				})
			}
			/*
				Checking on the last iteration whether PPR FILTERS SHEET exists or not 
			 */
			if (hasPprFilter.sheet === false && ws_arr.length === (ws_index + 1)) {
				filterByData["FILTERS"] = FILTERS;
				filterByData["hasPprFilter"] = hasPprFilter;

				// PPR_CUSTOM not available
				let _msg = 'Missing "PPR_CUSTOM worksheet" !!';
				showMissingFilterMsg(_msg);
			}
		});
	}

	function getUsername(params) {

		for (const param of params) {
			if (param.name === "pix Username") {
				return param.currentValue.value;
			}
		}
		return null;
	}

	function transformParam(param, encode = false) {
		return {
			name: encode ? encodeAndEscape(param.name) : param.name,
			value: encode ? encodeAndEscape(param.currentValue.value) : param.currentValue.formattedValue,
			encodedValue: encodeAndEscape(param.currentValue.value),
			useEncodedValue: selectedParameters.has(param.name) || (parametersPresentInDashboard.includes(param.name))
		};
	}

	function isIe() {
		// Opera 8.0+
		var isOpera = (!!window.opr && !!opr.addons) || !!window.opera || navigator.userAgent.indexOf(' OPR/') >= 0;

		// Firefox 1.0+
		var isFirefox = typeof InstallTrigger !== 'undefined';

		// Safari 3.0+ "[object HTMLElementConstructor]"
		var isSafari = /constructor/i.test(window.HTMLElement) || (function (p) { return p.toString() === "[object SafariRemoteNotification]"; })(!window['safari'] || (typeof safari !== 'undefined' && safari.pushNotification));

		// Internet Explorer 6-11
		var isIE = /*@cc_on!@*/false || !!document.documentMode;

		// Edge 20+
		var isEdge = !isIE && !!window.StyleMedia;

		// Chrome 1 - 71
		var isChrome = !!window.chrome && (!!window.chrome.webstore || !!window.chrome.runtime);

		// Blink engine detection
		var isBlink = (isChrome || isOpera) && !!window.CSS;

		return isIE;
	}

	function getDashboardFilter(sheetFilterMap) {
		let uniqueFilters = [];
		sheetFilterMap.forEach(function (sheet) {
			sheet.value.forEach(function (value) {
				// console.log("value", value);
				if (uniqueFilters != undefined) {
					let obj = uniqueFilters.find(function (filter) { filter.name === value.name });
					console.log("obj", obj);
					if (obj == undefined) {
						uniqueFilters.push(value);
					}
				} else {
					// console.log("value", value);
					uniqueFilters.push(value);
				}

			})
		})
		return uniqueFilters;
	}

	function setCookie(name,value,days) {
		var expires = "";
		if (days) {
			var date = new Date();
			date.setTime(date.getTime() + (days*24*60*60*1000));
			expires = "; expires=" + date.toUTCString();
		}
		document.cookie = name + "=" + (value || "")  + expires + "; path=/;domain="+window.location.hostname;
	}

	function getUserInfo() {
		return new Promise(function (resolve, reject) {
			const url = window.Configs.host + "/pps/config/user-info";
			const data = {
				server: tableauBaseUrl,
				viewURL: tableauWorkBook,
				username: UserName,
				siteName: siteName,
				tableauOnline: true
			};
			const stringifiedData = JSON.stringify(data);
			const headers = {
				'Content-Type': 'application/json',
				'Content-Length': stringifiedData.length
			}
			httpRequest(url, {
				method: 'POST',
				mode: 'cors',
				cache: 'no-cache',
				headers: headers,
				body: stringifiedData
			}).then(function (response) { return response.json() }).then(function (result) {
				resolve(result);
			}).catch(function (error) {
				reject(error);
			});
		})
	}


	function checkForSettings(settings) {
		if (Object.keys(settings).length > 0) {
			showLoader('Loading Settings');
			try {
				outputFormat = JSON.parse(settings.outputFormat);
				reportName = JSON.parse(settings.reportName);
				dataSourceSheet = JSON.parse(settings.dataSourceSheet);
				if (dataSourceSheet === null || dataSourceSheet === undefined) {
					dataSourceSheet = "";
				}
				ImageSourceSheet = JSON.parse(settings.ImageSourceSheet);
				reportingUrl = JSON.parse(settings.reportingUrl);
				reportingApplication = JSON.parse(settings.reportingApplication);
				authentication = JSON.parse(settings.authentication);
				paramData = JSON.parse(settings.selectedParameters);
				paramDataString = settings.selectedParameters;
				// multiReport & multiReportData belongs to Multiple Report Feature
				try {
					multiReport = JSON.parse(settings.multiReport);
				} catch (error) {
					console.log("Failed to read multiReport", error);
				}
				try {
					multiReportData = JSON.parse(settings.multiReportData);
				} catch (error) {
					console.log("Failed to read multiReportData", error);
				}

				try {
					customReportName = JSON.parse(settings.customReportName);
				} catch (error) {
					console.log("Failed to read Custom Report Name", error);
				}
				try {
					enableTimeStamp = JSON.parse(settings.enableTimeStamp);
				} catch (error) {
					console.log("Failed to read enable Time Stamp", error);
				}
				try {
					dateFormat = JSON.parse(settings.dateFormat);
				} catch (error) {
					console.log("Failed to read dateFormat", error);
					dateFormat = "yyyyMMdd";
				}
				try {
					generateTxtEnabled = JSON.parse(settings.generateTxtEnabled);
				} catch (error) {
					console.log("Failed to read generate As Txt", error);

				}
				try {
					encapsulateDataEnabled = JSON.parse(settings.encapsulateDataEnabled);
				} catch (error) {
					console.log("Failed to read encapsulate Headers", error);
				}
				try {
					arrWorkbookContentUrl = JSON.parse(settings.arrWorkbookContentUrl);
				} catch (error) {
					console.log("error in get workbook array", error);
				}
				try {
					dataSourceSheetContentUrlList = JSON.parse(settings.dataSourceSheetContentUrlList);
				} catch (error) {
					console.log("error in datasource sheet content url", error);
				}
				try {
					imageSourceSheetContentUrl = JSON.parse(settings.imageSourceSheetContentUrl)
				}
				catch (error) {
					console.log("error in image source url", error);
				}
				try {
					dynamicCsvOutputDelimiter = JSON.parse(settings.dynamicCsvOutputDelimiter);
				} catch (error) {
					console.log('Failed to read csv delimiter', error);
				}
				try {
					selectedColumns = JSON.parse(settings.selectedColumns);
				} catch (error) {
					console.log('Error parsing selected Columns');
				}
				const transposeDataFlag = settings.transposeData;
				if (outputFormat === 'dynamicCsv') {
					outputFormat = 'CSVD';
				}
				if (transposeDataFlag !== null && transposeDataFlag !== undefined && transposeDataFlag !== "") {
					tableauDataTranspose = JSON.parse(transposeDataFlag);
				}
				if ('dataOption' in settings) {
					const selectedOption = JSON.parse(settings.dataOption);
					switch (selectedOption) {
						case 'fullData':
							isSummaryData = false;
							break;
						case 'summaryData':
							isSummaryData = true;
							break;
						default:
							isSummaryData = false;
					}
				}
				console.log(outputFormat, reportName, dataSourceSheet, ImageSourceSheet, reportingUrl, reportingApplication, authentication);
				let tableauEnvironment = tableau.extensions.environment.context;
				console.log("tableauEnvironment", tableauEnvironment);
				if (tableauEnvironment == "desktop") {
					if ('tableauDesktopWorkbookName' in settings) {
						tableauWorkBook = settings.tableauDesktopWorkbookName;
					}
					if ('tableauDesktopSiteName' in settings) {
						siteName = settings.tableauDesktopSiteName;
					}
					if ('tableauDesktopTableauServer' in settings) {
						tableauBaseUrl = settings.tableauDesktopTableauServer;
					}
				}
				console.log("workbook and sitename", tableauWorkBook, siteName);

				getUserInfo().then(function (userInfo) {
					console.log("User Info: ", userInfo);
					const postData = {
						siteName: siteName,
						baseUrl: tableauBaseUrl,
						workbookUrl: tableauWorkBook.split("/")[0],
						apiVersion: apiVersion,
						username: UserName
					}
					// const encodedPostData = encodeData(postData);
					const headers = {
						'Content-Type': 'application/json',
						'Authorization': 'Bearer ' + userInfo.token,
						'Content-Length': JSON.stringify(postData).length
					};
					console.log("Post Data: ", postData, headers);
					httpRequest(window.Configs.host + "/pps/config/view-map", {
						method: 'POST',
						mode: 'cors',
						cache: 'no-cache',
						headers: headers,
						body: JSON.stringify(postData)
					}).then(function (response) { return response.json() }).then(function (result) {
						console.log("View Map: ", result);
						viewMap = result;
						let fileIconPath = "pdf.svg";
						if (outputFormat === "PDF") {
							fileIconPath = (multiReport ? "./icon_zip/pdf_zip.svg" : "pdf.svg");
							document.getElementById("ReportButton").src = fileIconPath;
						}
						else if (outputFormat === "HTML") {
							fileIconPath = (multiReport ? "./icon_zip/html_zip.svg" : "html.svg");
							document.getElementById("ReportButton").src = fileIconPath;
						}
						else if (outputFormat === "XLSX" || outputFormat === "XLS") {
							fileIconPath = (multiReport ? "./icon_zip/xls_zip.svg" : "xls.svg");
							document.getElementById("ReportButton").src = fileIconPath;
						}
						else if (outputFormat === "DOCX" || outputFormat === "DOC") {
							fileIconPath = (multiReport ? "./icon_zip/doc_zip.svg" : "doc.svg");
							document.getElementById("ReportButton").src = fileIconPath;
						}
						else if (outputFormat === "PPT" || outputFormat === "PPTX") {
							fileIconPath = (multiReport ? "./icon_zip/ppt_zip.svg" : "ppt.svg");
							document.getElementById("ReportButton").src = fileIconPath;
						}
						else if (outputFormat === "CSV") {
							fileIconPath = (multiReport ? "./icon_zip/csv_zip.svg" : "csv.svg");
							document.getElementById("ReportButton").src = fileIconPath;
						}
						else if (outputFormat === "CSVD") {
							fileIconPath = (multiReport ? "./icon_zip/csv_zip.svg" : "csv.svg");
							document.getElementById("ReportButton").src = fileIconPath;
						}
						else if (outputFormat === "PDFD") {
							fileIconPath = (multiReport ? "./icon_zip/pdf_zip.svg" : "pdf.svg");
							document.getElementById("ReportButton").src = fileIconPath;
						}
						// eslint-disable-next-line no-undef
						$('#inactive').hide();
						// eslint-disable-next-line no-undef
						$('#active').show();
						hideLoader();
					}).catch(function (error) {
						console.log("Error getting view map:", error);
						hideLoader();
					});
				}).catch(function (error) {
					console.log('Error getting user info: ', error);
					hideLoader();
					displaySnackBar({ message: 'Error getting user info: ', duration: 4000 });
				});
			} catch (error) {
				console.log('Error reading settings: ', error);
				hideLoader();
				displaySnackBar({ message: 'Error reading settings, re-configure: ', duration: 4000 });
			}
		}
	}

	function configure() {
		// eslint-disable-next-line no-undef
		if (!isTableauConfigured) {
			displaySnackBar({
				duration: 4000,
				message: 'Tableau Server not configured, Please contact Admin'
			});
			return;
		}
		if (isIeBrowser) {
			displaySnackBar({
				duration: 3000,
				message: 'Internet Explorer not supported for configuration! Please use Chrome/Firefix/Edge to configure'
			});
		} else {
			if (extensions.environment.context == "desktop") {
				let settings = extensions.settings.getAll();
				if (Object.keys(settings).length > 0) {
					openPixelPerfectServer()
				} else {
					openPPRConfigurationDesktop()
				}
			} else {
				openPixelPerfectServer();
			}
			// openPixelPerfectServer();
		}
	}

	function getUsernameUsingSheetData() {
		const worksheets = extensions.dashboardContent.dashboard.worksheets;
		return getSheetDataForUsername(worksheets, 0);
	}

	function getSheetDataForUsername(worksheets, index) {
		return new Promise(function (resolve, reject) {
			const summaryOptions = {
				maxRows: 0, // Max rows to return. Use 0 to return all rows
				ignoreAliases: false,
				ignoreSelection: false,
				includeAllColumns: true,
				summary: true,
				tableauDataTranspose: true
			};
			if (index < worksheets.length) {
				const sheetName = worksheets[index].name;
				getSheetData(sheetName, summaryOptions).then(function (sheetData) {
					const dataRow = sheetData && sheetData.length ? sheetData[0] : {};
					if (dataRow.hasOwnProperty('AsUser')) {
						UserName = dataRow.AsUser;
						console.log('Found AsUser: ', UserName);
						resolve(UserName);
					} else {
						resolve(getSheetDataForUsername(worksheets, ++index));
					}
				}).catch(function (error) {
					console.log('Error getting data for sheet: ', error);
					resolve(UserName);
				});
			} else {
				resolve(UserName);
			}
		});
	}

	function getSheetData(sheetName, options, appendSheetName) {
		return new Promise(function (resolve, reject) {
			const dashboard = extensions.dashboardContent.dashboard;
			const worksheets = dashboard.worksheets;
			let worksheet = worksheets.find(function (sheet) { return (sheet.name === sheetName) });
			let functionName = 'getUnderlyingDataAsync';
			if (options.summary) {
				functionName = 'getSummaryDataAsync';
			}
			worksheet[functionName](options).then(function (dataTable) {
				console.log(dataTable);
				let data = dataTable.data;
				let field2 = dataTable.columns.map(function (item) { return item["fieldName"] });
				let underlyingData = [];
				if (options.summary) {
					if (options.tableauDataTranspose) {
						console.log("Transposing data for ", sheetName);
						underlyingData = transposeData(dataTable);
					} else {
						console.log("Transpose disabled, Setting data without modification for ", sheetName);
						underlyingData = reduceToObjects(field2, data, appendSheetName ? sheetName : false);
					}
				} else {
					underlyingData = reduceToObjects(field2, data, appendSheetName ? sheetName : false);
				}
				console.log("Data: ", underlyingData);
				resolve(underlyingData);
			}).catch(function (error) {
				console.log("Error fetching data for sheet: ", error);
				resolve([]);
			});
		});
	}


	function transposeData(dataTable) {

		const columns = dataTable.columns.map(function (col) {
			let colName = col.fieldName;
			return colName.replace(/[^a-zA-Z0-9]/g, '_').replace(/^[^a-zA-Z]/, '_');
		});

		const fixedKeys = ['Measure_Names', 'Measure_Values'];
		const fixedKeysIndex = fixedKeys.map(function (key) { return columns.indexOf(key) });
		const fixedKeysSet = new Set();
		fixedKeysIndex.forEach(function (index) {
			fixedKeysSet.add(index);
		})
		const rowMap = {};
		dataTable.data.forEach(function (partialRow) {
			let key = '';
			partialRow.forEach(function (col, index) {
				if (!fixedKeysSet.has(index)) {
					key += partialRow[index].formattedValue;
				}
			});
			if (!rowMap.hasOwnProperty(key)) {
				rowMap[key] = partialRow.reduce(function (res, item, index) {
					const obj = {};
					obj[columns[index]] = item.formattedValue;
					return Object.assign(res, obj)
				}, {});
				fixedKeys.forEach(function (fixedKey) {
					delete rowMap[key][fixedKey];
				});
			}
			if (fixedKeysIndex[0] !== -1 && fixedKeysIndex[1] !== -1) {
				const obj = {};
				obj[partialRow[fixedKeysIndex[0]].formattedValue.replace(/[^a-zA-Z0-9]/g, '_').replace(/^[^a-zA-Z]/, '_')] = partialRow[fixedKeysIndex[1]].formattedValue;
				Object.assign(rowMap[key], obj);
			}
		});
		const transposedData = Object.keys(rowMap).map(function (key) { return rowMap[key] });
		return transposedData;
	}

	// For Tableau Desktop in case new extension is loaded
	function openPPRConfigurationDesktop(){
		const popupUrl = window.Configs.hostName;
		console.log("popupUrl", popupUrl);
		let openPayloadArray = [];
		let openPayloadMap = {};

		openPayloadMap["dashboardList"] = [];
		openPayloadMap["viewMap"] = { "data": [] };
		openPayloadMap["worksheets"] = JSON.stringify([]);
		openPayloadMap["userName"] = "";
		openPayloadMap["filterData"] = "";
		openPayloadMap["paramData"] = JSON.stringify({});
		openPayloadMap["contentUrl"] = "";
		openPayloadMap["ImageUrlList"] = "";
		openPayloadMap["dashboardName"] = "";
		openPayloadMap["showAdminTab"] = false; //showAdminTab
		openPayloadMap["configIDs"] = "";
		openPayloadMap["adminTabDisabled"] = false; //adminTabDisabled
		openPayloadMap["dashbordColumns"] = [];
		openPayloadMap["measureNames"] = [];
		openPayloadMap["sheetFilterMap"] = [];
		openPayloadMap["sessionToken"] = "";
		openPayloadMap["sampleData"] = sampleData;
		openPayloadMap["domainName"] = tableauBaseUrl;
		openPayloadMap["workbookName"] = tableauWorkBook;
		openPayloadMap["siteName"] = siteName;
		openPayloadMap["siteRole"] = "";
		openPayloadMap["selectedFilters"] = selectedFilters;
		openPayloadMap["filtersPresentInDashboard"] = filtersPresentInDashboard;

		openPayloadArray.push(openPayloadMap);
		let openPayloadString = "";
		openPayloadString = JSON.stringify(openPayloadArray);

		extensions.ui.displayDialogAsync(popupUrl, openPayloadString, { height: 720, width: 1400 })
			.then(function (closePayload) {
				$("#inactive").hide();
				$("#active").show();

				paramData = JSON.parse(closePayload);
				console.log("Close Payload Data - ParamData :", paramData);
			})
			.catch(function (error) {
				switch (error.errorCode) {

					case tableau.ErrorCodes.DialogClosedByUser:
						console.log("Prev ConfigIds : ", configIDs);
						console.log("Dialog was closed by user");
						break;
					default:
						console.error(error.message);
				}
			});
	}


	// Function to open PixelPerfectServer Instead of TabeDialog of PPR On Demand
	function openPixelPerfectServer() {
		const popupUrl = window.Configs.hostName;
		console.log("Popup Url", popupUrl);
		let worksheetArray = [];
		let worksheets = [];
		let dashboardName = "";
		let userName;
		let adminConfigurationSaved;
		let adminTabDisabled = false;
		let showAdminTab = true;
		let responseJson;
		let siteRole = "";
		let configIDs = "";

		let appliedFilters = [];
		let options = {
			maxRows: 0, // Max rows to return. Use 0 to return all rows
			ignoreAliases: false,
			ignoreSelection: false,
			includeAllColumns: true,
			summary: isSummaryData,
			tableauDataTranspose: tableauDataTranspose
		};

		dashboardName = extensions.dashboardContent.dashboard.name;
		console.log("Dashboard Name :", dashboardName);
		worksheetArray = extensions.dashboardContent.dashboard.worksheets;
		worksheetArray.forEach(function (worksheet) {
			worksheets.push(worksheet.name);
		});
		console.log("Worksheet Name : ", worksheets[0]);
		userName = UserName;
		let savedSettings = extensions.settings === undefined ? "" : extensions.settings.getAll();
		let tableauEnvironment = tableau.extensions.environment.context;
		console.log("tableauEnvironment", tableauEnvironment);
		if (tableauEnvironment == "desktop") {
			if ('tableauDesktopWorkbookName' in savedSettings) {
				tableauWorkBook = savedSettings.tableauDesktopWorkbookName;
			}
			if ('tableauDesktopSiteName' in savedSettings) {
				siteName = savedSettings.tableauDesktopSiteName;
			}
			if ('tableauDesktopTableauServer' in savedSettings) {
				tableauBaseUrl = savedSettings.tableauDesktopTableauServer;
			}
		}
		console.log("savedSettings in dasboard : ", savedSettings);
		let parameterObj = Object.keys(parameterObjMap).map(function (parameterName) { return parameterObjMap[parameterName] });
		let sheetFilterMap = [];
		Promise.all([getAppliedFiltersForMapping()]).then(function (parameterAndFilter) {
			sheetFilterMap = parameterAndFilter[0];

			console.log("parameterAndFilter", parameterAndFilter);
			const encode = false;

			if (extensions.environment.mode === "authoring") {
				adminTabDisabled = false;
			} else {
				adminTabDisabled = true;
			}
			console.log("Working settings tab status : ", adminTabDisabled);
			var url = window.Configs.host + "/pps/config/user-info";
			if (tableauBaseUrl !== "" && tableauWorkBook !== "") {
				adminConfigurationSaved = true;
				const data = {
					server: tableauBaseUrl,
					viewURL: tableauWorkBook,
					username: UserName,
					siteName: siteName,
					tableauOnline: true
				};
				// eslint-disable-next-line no-undef
				$.ajax({
					type: "POST",
					url: url,
					async: false,
					data: JSON.stringify(data),
					headers: {
						'Accept': 'application/json',
						'Content-Type': 'application/json'
					},
					success: function (data) {
						console.log(data);
						responseJson = data;
						siteRole = responseJson.siteRole;
						configIDs = responseJson.config_ids;
						sessionToken = responseJson.token;

						localStorage.setItem('sessionToken', sessionToken);
						switch (siteRole) {
							case "ServerAdministrator":
							case "SiteAdministratorCreator":
							case "Creator":
							case "SiteAdministratorExplorer":
								showAdminTab = true;
								break;
							case "Explorer":
							case "ExplorerCanPublish":
							case "Viewer":
							case "Unlicensed":
							default:
								showAdminTab = false;
						}
					},
					dataType: "json"
				});
			} else {
				adminConfigurationSaved = false;
				const data = {
					server: "",
					viewURL: "",
					username: UserName
				};

				// eslint-disable-next-line no-undef
				$.ajax({
					type: "POST",
					url: url,
					async: false,
					data: JSON.stringify(data),
					headers: {
						'Accept': 'application/json',
						'Content-Type': 'application/json'
					},
					success: function (data) {
						console.log("Data", data);
						responseJson = data;
						siteRole = responseJson.siteRole;
						configIDs = responseJson.config_ids;
						sessionToken = responseJson.token;


						switch (siteRole) {
							case "ServerAdministrator":
							case "SiteAdministratorCreator":
							case "Creator":
							case "SiteAdministratorExplorer":
								showAdminTab = true;
								break;
							case "Explorer":
							case "ExplorerCanPublish":
							case "Viewer":
							case "Unlicensed":
							default:
								showAdminTab = false;
						}
					},
					dataType: "json"
				});
				console.log("Response ", responseJson);
			}
		}).then(function (resp) {

			const postData = {
				siteName: siteName,
				baseUrl: tableauBaseUrl,
				workbookUrl: tableauWorkBook,
				apiVersion: apiVersion,
				username: userName
			}
			// const encodedPostData = encodeData(postData);
			const headers = {
				'Content-Type': 'application/json',
				'Authorization': 'Bearer ' + sessionToken,
				'Content-Length': JSON.stringify(postData).length
			};
			console.log("Post Data: ", postData, headers);
			httpRequest(window.Configs.host + "/pps/config/view-map", {
				method: 'POST',
				mode: 'cors',
				cache: 'no-cache',
				headers: headers,
				body: JSON.stringify(postData)
			}).then(function (response) { console.log("response", response); return response.json() })
				.then(function (result) {
					console.log("View Map: ", result);
					viewMap = result;
				})

				.then(function (resp) {
					let dashboardList = [];
					let dashboardFilter = sheetFilterMap[sheetFilterMap.findIndex(function (sheet) { return (sheet.name === dashboardName) })]['value'];

					viewMap.forEach(function (view) {
						const searchIndex = sheetFilterMap.findIndex(function (sheet) { (sheet.name === view.name) });
						if (searchIndex == -1) {
							let obj = {};
							obj['name'] = view.name;
							obj['value'] = dashboardFilter;
							dashboardList.push(obj);
						}
					})

					sheetFilterMap = sheetFilterMap.concat(dashboardList);

					console.log("sheetFilterMap", sheetFilterMap);

					let tableauEnvironment = tableau.extensions.environment.context;
					if (tableauEnvironment == "server") {
						var currentSettings = window.tableau.extensions.settings.getAll();
						window.tableau.extensions.settings.set("tableauDesktopWorkbookName", tableauWorkBook);
						window.tableau.extensions.settings.set("tableauDesktopSiteName", siteName);
						window.tableau.extensions.settings.set("tableauDesktopTableauServer", tableauBaseUrl);
						window.tableau.extensions.settings.saveAsync();
					}

					let openPayloadArray = [];
					let openPayloadMap = {};

					openPayloadMap["dashboardList"] = dashboardList;
					openPayloadMap["viewMap"] = { "data": viewMap };
					openPayloadMap["worksheets"] = JSON.stringify(worksheets);
					openPayloadMap["userName"] = userName;
					openPayloadMap["filterData"] = "";
					openPayloadMap["paramData"] = JSON.stringify(parameterObj);
					openPayloadMap["contentUrl"] = "";
					openPayloadMap["ImageUrlList"] = "";
					openPayloadMap["dashboardName"] = dashboardName;
					openPayloadMap["showAdminTab"] = showAdminTab; //showAdminTab
					openPayloadMap["configIDs"] = configIDs;
					openPayloadMap["adminTabDisabled"] = adminTabDisabled; //adminTabDisabled
					openPayloadMap["dashbordColumns"] = [];
					openPayloadMap["measureNames"] = [];
					openPayloadMap["sheetFilterMap"] = sheetFilterMap;
					openPayloadMap["sessionToken"] = sessionToken;
					openPayloadMap["sampleData"] = sampleData;
					openPayloadMap["domainName"] = tableauBaseUrl;
					openPayloadMap["workbookName"] = tableauWorkBook;
					openPayloadMap["siteName"] = siteName;
					openPayloadMap["siteRole"] = siteRole;
					openPayloadMap["selectedFilters"] = selectedFilters;
					openPayloadMap["filtersPresentInDashboard"] = filtersPresentInDashboard;
					openPayloadMap["filterByData"] = JSON.stringify(filterByData);
					console.log("Payload Data :", openPayloadMap);
					openPayloadArray.push(openPayloadMap);
					let openPayloadString = "";
					console.log("Mapped Filter : " + JSON.stringify([]));
					openPayloadString = JSON.stringify(openPayloadArray);
					if (adminConfigurationSaved === false && showAdminTab === false) {
						console.log("Admin Configuration is not saved");
					} else {
						extensions.ui.displayDialogAsync(popupUrl, openPayloadString, { height: 720, width: 1400 })
							.then(function (closePayload) {
								// The promise is resolved when the dialog has been expectedly closed, meaning that
								// the popup extension has called extensions.ui.closeDialog.
								// eslint-disable-next-line no-undef
								$("#inactive").hide();
								// eslint-disable-next-line no-undef
								$("#active").show();
								console.log("ClosePayload String Returned : ", closePayload);
								paramData = JSON.parse(closePayload);
								console.log("Close Payload Data - ParamData :", paramData);
							})
							.catch(function (error) {
								switch (error.errorCode) {
									// eslint-disable-next-line no-undef
									case tableau.ErrorCodes.DialogClosedByUser:
										console.log("Prev ConfigIds : ", configIDs);
										console.log("Dialog was closed by user");
										break;
									default:
										console.error(error.message);
								}
							});
					}
				});
			// }); //All Filter Commented 
		});
	}

	// Filter Mapping to content url for handling PPR Server
	function getAppliedFiltersForMapping() {
		return new Promise(function (resolve, reject) {
			let filterFetchPromises = [];
			let dashboardfilters = [];
			dashboard.worksheets.forEach(function (worksheet) {
				filterFetchPromises.push(worksheet.getFiltersAsync());
			});

			// Now, we call every filter fetch promise, and wait for all the results
			// to finish before displaying the results to the user.
			Promise.all(filterFetchPromises).then(function (fetchResults) {
				fetchResults.forEach(function (filtersForWorksheet) {
					let sheetFilter = [];
					let sheetName = "";
					let sheetFilterObj = {};

					filtersForWorksheet.forEach(function (filter) {
						sheetName = filter.worksheetName;
						let tempFilterObj = formatSheetFilter(filter);
						if (tempFilterObj != null) {
							sheetFilter.push(tempFilterObj);
						}

					});
					sheetFilterObj["name"] = sheetName;
					sheetFilterObj["value"] = sheetFilter;
					dashboardfilters.push(sheetFilterObj);
				});
				const dashboardSheetFilterEntry = {};
				dashboardfilters.forEach(function (sheetFilterObj) {
					if (sheetFilterObj && sheetFilterObj.value && sheetFilterObj.value instanceof Array) {
						sheetFilterObj.value.forEach(function (filterObj) {
							dashboardSheetFilterEntry[filterObj.name] = filterObj;
						});
					}
				});
				console.log('Dashboard Filters Entry Map: ', dashboardSheetFilterEntry);
				const dashboardFilterMap = { name: dashboard.name, value: Object.keys(dashboardSheetFilterEntry).map(function (key) { return dashboardSheetFilterEntry[key] }) };
				console.log('Dashboard Filter Map: ', dashboardFilterMap);
				dashboardfilters.push(dashboardFilterMap);
				resolve(dashboardfilters);
			}).catch(function (err) {
				reject(err);
			});
		});
	}

	function formatSheetFilter(filter) {
		if (filter.fieldName.indexOf("Measure Names") < 0 && filter.fieldName.indexOf("Metric Type") < 0 && filter.fieldName.indexOf("Most Recent or prior year") < 0 && filter.fieldName.indexOf("AGG(Count or Amount calc)") < 0 && filter.fieldName.indexOf("Null State") < 0 && !excludedFilters.has(filter.fieldName) && filter.fieldName.indexOf("Action (") < 0 && filter.filterType.indexOf("range") < 0) {
			let formatSheetFilterValues = {};
			let filterName = filter.fieldName;
			const filterValue = getMappedFilterValues(filter);
			const decodedFilters = decodeURIComponent(filterValue);
			const encodedFilters = getFilterValues(filter, true);
			const modifiedFilters = { name: filterName, value: decodedFilters, useEncodedValue: selectedFilters.has(filterName), encodedValue: encodedFilters, filterType: filter.filterType, minRange: filter.filterType === "range" ? filter.minValue.formattedValue : "Null", maxRange: filter.filterType === "range" ? filter.maxValue.formattedValue : "Null", isAllSelected: filter.isAllSelected };
			formatSheetFilterValues = modifiedFilters;
			return formatSheetFilterValues;
		}
		return null;
	}

	function getMappedFilterValues(filter) {
		let filterValues = '';

		switch (filter.filterType) {
			case 'categorical':
				filter.appliedValues.forEach(function (value) {
					filterValues += encodeURIComponent(value.formattedValue) + ',';
				});
				break;
			case 'range':
				// A range filter can have a min and/or a max.
				if (filter.minValue) {
					filterValues += 'min: ' + filter.minValue.formattedValue + ',';
				}

				if (filter.maxValue) {
					filterValues += 'min: ' + filter.maxValue.formattedValue + ',';
				}
				break;
			case 'relative-date':
				filterValues += 'Period: ' + filter.periodType + ',';
				filterValues += 'RangeN: ' + filter.rangeN + ',';
				filterValues += 'Range Type: ' + filter.rangeType + ',';
				break;
			default:
		}

		// Cut off the trailing ", "
		return filterValues.slice(0, -1);
	}

	function encodeData(postData) {
		let encodedPostData = '';
		Object.keys(postData).forEach(function (field) {
			encodedPostData += $.validator.format("{0}={1}&", [encodeURIComponent(field), encodeURIComponent(postData[field])]);
		});
		if (encodedPostData.length) {
			encodedPostData = encodedPostData.slice(0, encodedPostData.length - 1);
		}
		return encodedPostData;
	}

	function httpRequest(url, options) {
		return new Promise(function (resolve, reject) {
			fetch(url, options).then(function (response) {
				resolve(response);
			}).catch(function (error) {
				reject(error);
			});
		});
	}

	function encodeAndEscape(text) {
		return encodeURIComponent(text).replace(/%2C/g, '%5C%2C').replace(/%3F/g, '%5C%3F').replace(/%26/g, '%5C%26');
	}

	function getFormattedDate(date, separator) {
		if (!separator) {
			separator = '-';
		}
		const month = date.getMonth() + 1;
		const monthFormatted = (month < 10 ? '0' : '') + month;
		const day = date.getDate();
		const dayFormatted = (day < 10 ? '0' : '') + day;
		const dateString = date.getFullYear() + "-" + monthFormatted + "-" + dayFormatted;
		return dateString;
	}

	function getAppliedParameters() {
		return new Promise(function (resolve, reject) {
			extensions.dashboardContent.dashboard.getParametersAsync().then(function (params) {
				resolve(params);
			}).catch(function (err) {
				console.log('Error occured while getting Parameter values');
			});
		});
	}

	function getFilterValues(filter, encode) {
		let filterValues = '';

		switch (filter.filterType) {
			case 'categorical':
				filter.appliedValues.forEach(function (value) {
					let filterValue = value.formattedValue;
					if (encode) {
						if (Object.prototype.toString.call(value.value) === '[object Date]') {
							filterValue = encodeAndEscape(getFormattedDate(value.value));
						} else if (value.value === '%null%') {
							filterValue = '~~null~';
						} else if (value.formattedValue === 'Null' && (value.value === undefined || isNaN(value.value))) {
							filterValue = '~~null~';
						} else if (value.formattedValue === 'Null' && value.value === true) { // condition for Boolean Filters, always return true for Null, True and False values.
							filterValue = '~~null~';
						} else if (value.formattedValue === 'False' && value.value === true) {  // condition for Boolean Filters, always return true for Null, True and False values.
							filterValue = 'false';
						} else if (value.value === null) {
							filterValue = '';
						} else {
							filterValue = encodeAndEscape(value.value);
						}
						filterValues += filterValue + ',';
					} else {
						filterValues += filterValue + ', ';
					}

				});
				if (!encode && filterValues.length) {
					filterValues = filterValues.slice(0, -1);
				}
				break;
			case 'range':
				// A range filter can have a min and/or a max.
				if (filter.minValue) {
					filterValues += (encode ? encodeAndEscape('min: ' + filter.minValue.formattedValue) : ('min: ' + filter.minValue.formattedValue)) + ',';
				}

				if (filter.maxValue) {
					filterValues += (encode ? encodeAndEscape('max: ' + filter.maxValue.formattedValue) : ('max: ' + filter.maxValue.formattedValue)) + ',';;
				}
				break;
			case 'relative-date':
				filterValues += (encode ? encodeAndEscape('Period: ' + filter.periodType) : ('Period: ' + filter.periodType)) + ',';
				filterValues += (encode ? encodeAndEscape('RangeN: ' + filter.rangeN) : ('RangeN: ' + filter.rangeN)) + ',';
				filterValues += (encode ? encodeAndEscape('Range Type: ' + filter.rangeType) : ('Range Type: ' + filter.rangeType)) + ',';
				break;
			default:
		}
		return filterValues.slice(0, -1);
	}

	function displaySnackBar(options) {
		const defaultOptions = { color: 'white', backgroundColor: '#00900f', message: '' };
		Object.assign(defaultOptions, options);
		console.log('Snackbar Options: ', defaultOptions);
		const snackBar = document.getElementById('snackbar');
		snackBar.style.display = 'block';
		const snackBarContent = document.getElementsByClassName('snackbar-content')[0];
		snackBarContent.innerText = defaultOptions.message;
		snackBar.style.display = 'flex';
		snackBarContent.style.setProperty('color', defaultOptions.color);
		snackBarContent.style.setProperty('background-color', defaultOptions.backgroundColor);
		if (defaultOptions.duration) {
			setTimeout(function () {
				snackBar.style.display = 'none';
				console.log('Hid snackbar');
			}, defaultOptions.duration);
		}
	}

	function showLoader(message) {
		const spinnerElement = document.getElementById('spinner');
		const container = document.getElementById('container');
		spinnerElement.style.display = "flex";
		container.style.display = "none";
		displaySnackBar({
			message: message
		});
	}

	function hideLoader() {
		const spinnerElement = document.getElementById('spinner');
		const container = document.getElementById('container');
		const snackBar = document.getElementById('snackbar');
		snackBar.style.display = 'none';
		spinnerElement.style.display = "none";
		container.style.display = "block";
	}

	function getDataAndSubmitForm(event) {
		let displayFormat = outputFormat;
		if (displayFormat === 'CSVD') {
			displayFormat = 'CSV'
		} else if (displayFormat === 'PDFD') {
			displayFormat = 'PDF'
		}
		let dataSourceDashboard = extensions.dashboardContent.dashboard.name;
		showLoader("Generating " + displayFormat + " report");
		event.preventDefault();
		const postData = {
			jsonData: '[]',
			filterData: '[]',
			parameterData: '[]',
			userName: UserName,
			filterString: '',
			contentUrl: '',
			timeStamp: '',
			baseUrl: tableauBaseUrl,
			siteName: siteName,
			workbookUrl: (Array.isArray(arrWorkbookContentUrl) && arrWorkbookContentUrl.length > 0 ? arrWorkbookContentUrl : [tableauWorkBook]),
			selectedColumns: JSON.stringify(selectedColumns),
			transposeData: tableauDataTranspose,
			dynamicCsvOutputDelimiter,
			dataSourceDashboard,
			customReportName,
			enableTimeStamp,
			dateFormat,
			encapsulateDataEnabled,
			generateTxtEnabled,
			multiReport,
			multiReportData
		};
		let ImageArray = [];
		if (ImageSourceSheet !== "") {
			ImageArray = ImageSourceSheet.split(",");
		}
		console.log("Image Array :" + ImageArray);
		let contentURL = "";
		if (imageSourceSheetContentUrl == "") {
			contentURL = ImageArray.map(function (imageSheetName) { return viewMap.find(function (view) { return view.name === imageSheetName }).contentUrl });
		}
		Promise.all([getAppliedFiltersForMapping()]).then(function (parameterAndFilter) {
			sheetFilterMap = parameterAndFilter[0];
			const encode = false;
			const parameterObj = Object.keys(parameterObjMap).map(function (parameterName) { return parameterObjMap[parameterName] });
			postData.parameterData = JSON.stringify(parameterObj);

			if (imageSourceSheetContentUrl != "") {
				postData.contentUrl = imageSourceSheetContentUrl;
			}
			else {
				const contentUrlString = contentURL.join(',');
				console.log("ContentUrl: " + contentUrlString, contentUrlString.split(","));
				postData.contentUrl = contentUrlString;
			}
			let dataSourceList = dataSourceSheet !== "" ? dataSourceSheet.split(",") : [];
			Promise.all([getAppliedFilters(dataSourceList)]).then(function (res) {
				console.log('Promise result: ', res);

				// Get all Applied filter on dashboard
				const appliedFilters = res[0];
				// eslint-disable-next-line no-undef
				urlString = urlBase;
				console.log('URL for POST: ', urlString);
				//Code to get date time stamp
				const monthNames = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
				let now = new Date();
				let monthName = monthNames[now.getMonth()];
				let timeStamp = monthName + ' ' + now.getDate() + ' ' + now.getFullYear() + ', ' + now.getHours() + ':' + now.getMinutes() + ':' + now.getSeconds();
				console.log("timeStamp : " + timeStamp);
				postData.timeStamp = timeStamp;
				// Set user name
				postData.userName = UserName;
				console.log("User Name : " + UserName);

				postData.reportName = reportName;
				postData.outputFormat = outputFormat;
				postData.dataSourceSheet = dataSourceSheet;

				// Get data and set data and filters
				let options = {
					maxRows: 0, // Max rows to return. Use 0 to return all rows
					ignoreAliases: false,
					ignoreSelection: false,
					includeAllColumns: true,
					summary: isSummaryData,
					tableauDataTranspose: tableauDataTranspose
				};

				let worksheetListArray = extensions.dashboardContent.dashboard.worksheets;
				let worksheetsName = [];
				// worksheetListArray.forEach(function (worksheet) {
				// 	worksheetsName.push(worksheet.name);
				// });

				// Promise.all(dataSourceList.map(function (sheetName) { return getSheetData(sheetName, options) })).then(function (mergedData) {
				Promise.all(worksheetsName.map(function (sheetName) { return getSheetData(sheetName, options) })).then(function (mergedData) {
					console.log("Merged Data: ", mergedData);
					const filterMap = getFilterMap(appliedFilters.map(function (item) { return item.fieldName.replace(/[^a-zA-Z0-9]/g, '_') }), mergedData);
					console.log('Filtermap: ', filterMap);
					// Iterate through filters and set correct keys and values
					let formattedFilters = [];
					const filtersAdded = new Set();
					appliedFilters.forEach(function (filter) {
						let filterName = filter.fieldName;
						if (!(filtersAdded.has(filterName + filter.filterType) || excludedFilters.has(filterName))) {
							let filterValue = getFilterValues(filter, false);
							const filterKey = filterName.replace(/[^a-zA-Z0-9]/g, '_');
							if (filter.isAllSelected) {
								if (filterMap.hasOwnProperty(filterKey)) {
									filterValue = Array.from(filterMap[filterKey]).join(", ");
								}
							}
							// For isAllSelected value in object use latest tableau extension Library
							const modifiedFilters = {
								name: filterName,
								value: filterValue,
								encodedValue: getFilterValues(filter, true),
								useEncodedValue: selectedFilters.has(filterName) || (filter.isAllSelected === false && filterValue !== "" && filtersPresentInDashboard.includes(filterName)),
								filterType: filter.filterType,
								minRange: filter.filterType === "range" ? filter.minValue.formattedValue : "Null",
								maxRange: filter.filterType === "range" ? filter.maxValue.formattedValue : "Null",
								isAllSelected: filter.isAllSelected
							};
							formattedFilters.push(modifiedFilters);
							filtersAdded.add(filterName + filter.filterType);
						}
					});
					let filterData = JSON.stringify(formattedFilters);
					console.log('Filter data 1 from promise: ', filterData);
					postData.filterData = filterData;
					console.log('Filter data 2 from promise: ', postData.filterData);
					let sheetNameAll = [];

					//Mapping datasource contenturl with Filter name List

					let mappedDatasourceFilter = {};
					if (dataSourceSheetContentUrlList == "") {
						dataSourceList.forEach(function (sheet) {
							let sheetContentUrl = viewMap.find(function (element) { return element.name == sheet }).contentUrl;
							sheetNameAll.push(sheetContentUrl);
						});
					}
					else {
						sheetNameAll = dataSourceSheetContentUrlList;
					}
					dataSourceList.concat(ImageArray).forEach(function (sheet) {
						let mappedFilterObj = sheetFilterMap.find(function (element) { return element.name == sheet });
						if (mappedFilterObj) {
							const mappedFilter = mappedFilterObj.value;
							let dataSourceSheetObj = viewMap.find(function (element) { return element.name == sheet }).contentUrl;
							let sheetFilters = [];
							mappedFilter.forEach(function (filter) {
								sheetFilters.push(filter.name);
							})
							mappedDatasourceFilter[dataSourceSheetObj] = sheetFilters;
						}
					});
					console.log("mappedDatasourceFilter", mappedDatasourceFilter);
					postData.filterString = JSON.stringify(mappedDatasourceFilter);

					var d = new Date();
					var offset = d.getTimezoneOffset();
					postData.clientOffset = offset;
					console.log("Final POST Data: ", postData);

					// postData.jsonData = JSON.stringify(jsonDataAll);
					if(dataSourceSheetContentUrlList == "") {
						postData.sheets = sheetNameAll.join(',');
					}
					else {
						postData.sheets = sheetNameAll;
					}
					
					

					let responseHeaders;
					//SS START
					getUserInfo().then(function (userInfo) {
						console.log("User Info: ", userInfo);
						const headers = {
							'Content-Type': 'application/json',
							'Content-Length': postData.length,
							'Authorization': 'Bearer ' + userInfo.token,
						};

						const postOptions = {
							method: 'POST',
							mode: 'cors',
							headers: headers,
							body: JSON.stringify(postData)
						};

						console.log("Post Data: ", postData, headers);
						httpRequest(urlString, postOptions).then(function (response) {
							responseHeaders = response.headers;
							response.blob().then(function (blob) {
								console.log(responseHeaders);
								const contentDispositionHeader = responseHeaders.get('content-disposition');
								let outputF = outputFormat.toLowerCase();
								if (outputF === 'csvd') {
									outputF = 'zip';
								} else if (outputF === 'ppt') {
									outputF = 'pptx';
								} else if (outputF === "pdfd") {
									outputF = 'pdf';
								}
								if (multiReport == true){
									outputF = 'zip';
								}
								//let outputF =  outputFormat.toLowerCase()==='csvd'?'csv': outputFormat.toLowerCase();
								let fileName = reportName + "." + outputF;
								if (contentDispositionHeader !== null && contentDispositionHeader !== undefined && contentDispositionHeader !== "") {
									fileName = contentDispositionHeader.split("=").pop();
								}
								if (window.navigator.msSaveOrOpenBlob) {
									// IE11
									console.log("Saving blob to file");
									window.navigator.msSaveOrOpenBlob(blob, fileName);
								} else {
									var url = window.URL.createObjectURL(blob);
									var a = document.createElement('a');
									a.href = url;
									a.download = fileName;
									document.body.appendChild(a);
									a.click();
									a.remove();
								}
								hideLoader();
							}).catch(function (error) {
								console.log('Error downloading report: ', error);
								hideLoader();
							});
						});
					}).catch(function (error) {
						console.log('Error generating report: ', error);
						hideLoader();
						displaySnackBar({ message: 'Error generating report.', duration: 6000, backgroundColor: '#eb5e34' });
					});
				}).catch(function (error) {
					console.log("Error fetching data for selected sheets: ", error);
					hideLoader();
				});


			}).catch(function (err) {
				console.log('Error while posting', err);
				hideLoader();
			});
		});
	}


	// For getting all filters value when ALL is selected
	function getFilterMap(allFilterSelected, mergedData) {
		//For getting the sheets from where datasource to be fetched
		const filterNameSet = new Set(allFilterSelected);
		const filterMap = {};
		mergedData.forEach(function (sheetData) {
			sheetData.forEach(function (dataRow) {
				Object.keys(dataRow).forEach(function (fieldName) {
					if (filterNameSet.has(fieldName)) {
						if (!filterMap.hasOwnProperty(fieldName)) {
							filterMap[fieldName] = new Set();
						}
						filterMap[fieldName].add(dataRow[fieldName]);
					}
				});
			})
		});
		return filterMap;
	}

	function getAppliedFilters(ds) {
		return new Promise(function (resolve, reject) {
			let filterFetchPromises = [];
			let dashboardfilters = [];
			console.log("Sheets are :", ds);
			// eslint-disable-next-line no-undef
			for (let p = 0; p < ds.length; p++) {
				const datasource = ds[p];
				dashboard.worksheets.forEach(function (worksheet) {
					if (worksheet.name === datasource) {
						filterFetchPromises.push(worksheet.getFiltersAsync());
					}
				});
				if (dashboard.name == datasource) {
					worksheets = dashboard.worksheets;
					filterFetchPromises.push(worksheets[0].getFiltersAsync());
				}
			}

			// Now, we call every filter fetch promise, and wait for all the results
			// to finish before displaying the results to the user.
			Promise.all(filterFetchPromises).then(function (fetchResults) {
				fetchResults.forEach(function (filtersForWorksheet) {
					filtersForWorksheet.forEach(function (filter) {
						dashboardfilters.push(filter);
					});
				});

				console.log("Filter Changed ", dashboardfilters);
				resolve(dashboardfilters);
			}).catch(function (err) {
				reject(err);
			});

		});
	}

	function reduceToObjects(cols, data, sheetName) {
		const columns = cols.map(function (col) {
			let colName = ((sheetName ? (sheetName + '_') : '') + col).replace(/[^a-zA-Z0-9]/g, '_');
			if (colName.search(/^[^a-zA-Z]/) === 0) {
				colName = "_" + colName;
			}
			return colName;
		});
		const dataToReturn = data.map(function (row) {
			return row.reduce(function (res, item, index) {
				const currProp = {};
				currProp[columns[index]] = item.formattedValue;
				return Object.assign(res, currProp);
			}
				, {});
		});
		return dataToReturn;
	}

})();
