REATE TABLE ppserver.service_url_config (
    id bigint NOT NULL,
    url character varying,
    status boolean DEFAULT true,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying
);


ALTER TABLE ppserver.service_url_config OWNER TO ppradmin;

--
-- TOC entry 228 (class 1259 OID 74226)
-- Name: service_url_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.service_url_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.service_url_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- TOC entry 233 (class 1259 OID 74254)
-- Name: sftp_config_master; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.sftp_config_master (
    id bigint NOT NULL,
    host character varying NOT NULL,
    port character varying,
    admin_user character varying NOT NULL,
    sftp_endpoint character varying NOT NULL,
    jwt_token_endpoint character varying,
    admin_token character varying,
    push_sftp_flag character varying,
    path_placeholder character varying,
    status boolean,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying
);


ALTER TABLE ppserver.sftp_config_master OWNER TO ppradmin;

--
-- TOC entry 234 (class 1259 OID 74260)
-- Name: sftp_config_master_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.sftp_config_master ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.sftp_config_master_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);

CREATE TABLE ppserver.smtp_config (
    id bigint NOT NULL,
    mail_password character varying NOT NULL,
    mail_from character varying NOT NULL,
    mail_host character varying NOT NULL,
    mail_port character varying NOT NULL,
    mail_type character varying NOT NULL,
    file_max_size bigint,
    status boolean DEFAULT true,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying,
    mail_secure boolean,
    username character varying
);


ALTER TABLE ppserver.smtp_config OWNER TO ppradmin;

--
-- TOC entry 232 (class 1259 OID 74245)
-- Name: smtp_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.smtp_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.smtp_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- TOC entry 229 (class 1259 OID 74228)
-- Name: ssl_config; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.ssl_config (
    id bigint NOT NULL,
    key_file character varying,
    certificate_file character varying,
    key_passphrase character varying,
    chain_file character varying,
	keystore_flag boolean DEFAULT false,
    ssl_enabled boolean NOT NULL,
    status boolean DEFAULT true,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying,
    keystore_file character varying,
    key_store_password character varying,
	keystore_type character varying ,
	key_alias character varying
);


ALTER TABLE ppserver.ssl_config OWNER TO ppradmin;

--
-- TOC entry 230 (class 1259 OID 74234)
-- Name: ssl_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.ssl_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.ssl_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- TOC entry 235 (class 1259 OID 74262)
-- Name: storage_config; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.storage_config (
    id bigint NOT NULL,
    environment_type character varying NOT NULL,
    status boolean,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying,
    report_output_path character varying,
    reports_bucket_path character varying,
    templates_bucket_path character varying,
    templates_path character varying
);


ALTER TABLE ppserver.storage_config OWNER TO ppradmin;

--
-- TOC entry 236 (class 1259 OID 74268)
-- Name: storage_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.storage_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.storage_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- TOC entry 225 (class 1259 OID 65930)
-- Name: tableau_config; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.tableau_config (
    id bigint NOT NULL,
    server character varying NOT NULL,
	name character varying ,
    api_version character varying,
    username character varying NOT NULL,
    password character varying NOT NULL,
    status boolean DEFAULT true,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying
);


ALTER TABLE ppserver.tableau_config OWNER TO ppradmin;

--
-- TOC entry 226 (class 1259 OID 65933)
-- Name: tableau_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.tableau_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.tableau_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);

CREATE TABLE ppserver.services_config (
    id bigint NOT NULL,
	service_display_name character varying,
	service_name character varying,
	service_description character varying,
	service_endpoint character varying,
	status boolean DEFAULT true,
	created_at timestamp with time zone,
	created_by character varying,
	modified_at timestamp with time zone,
	modified_by character varying
);


ALTER TABLE ppserver.services_config OWNER TO ppradmin;

--
-- TOC entry 228 (class 1259 OID 74226)
-- Name: services_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.services_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
	SEQUENCE NAME ppserver.services_config_id_seq
	START WITH 1
	INCREMENT BY 1
	NO MINVALUE
	NO MAXVALUE
	CACHE 1
);

CREATE TABLE ppserver.alerts (
	id bigint NOT NULL,
	severity character varying,
	description character varying,
	service_api character varying,
	status boolean DEFAULT true,
	created_at timestamp without time zone,
	created_by character varying,
	modified_at timestamp without time zone,
	modified_by character varying
);


ALTER TABLE ppserver.alerts OWNER TO ppradmin;

--
-- TOC entry 228 (class 1259 OID 74226)
-- Name: alerts_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.alerts ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
	SEQUENCE NAME ppserver.alerts_id_seq
	START WITH 1
	INCREMENT BY 1
	NO MINVALUE
	NO MAXVALUE
	CACHE 1
);

INSERT INTO ppserver.services_config(
service_name, service_description, service_endpoint, status, created_at, created_by, modified_at, modified_by, service_display_name)
VALUES ('PixelPerfectAPI' , 'Main service which serves all the requests from UI either independently or by delegating the required tasks to Scheduler and ReportEngine services.'
, 'http://localhost:80/', true, now(), 'admin', now(), 'admin', 'Pixel Perfect API'),
('PixelPerfectScheduler' , 'Service to handle scheduling of jobs and trigger report engine accordingly.'
, 'http://localhost:8098/', true, now(), 'admin', now(), 'admin', 'Pixel Perfect Scheduler'),
('PixelPerfectReportEnigne' , 'Service which handles the on-demand, scheduled report generation requests as well as report bursts.'
, 'http://localhost:8099/', true, now(), 'admin', now(), 'admin', 'Pixel Perfect Report Engine');

