#!/bin/bash
# Pixel Perfect New Installation
SRC_DIR=$(pwd)
DEST_DIR=/opt/pixelperfect
echo "You have selected New Installation"
# JDK installation
sudo mkdir -p /opt/pixelperfect/output_files
#sudo cp -r java-se-8u41-ri "$DEST_DIR"
JAVA_HOME="$DEST_DIR"/java-se-8u41-ri
export JAVA_HOME=$JAVA_HOME
echo "export JAVA_HOME=${JAVA_HOME}" | sudo tee /etc/profile.d/openjdk.sh
echo "export JRE_HOME=${JAVA_HOME}/jre" | sudo tee -a /etc/profile.d/openjdk.sh
echo "export PATH=$PATH:${JAVA_HOME}/bin" | sudo tee -a /etc/profile.d/openjdk.sh
source /etc/profile
java -version
sudo ln -s /usr/lib64/libreadline.so.7 /usr/lib64/libreadline.so.6
sudo ln -s "$DEST_DIR"/pgsql/lib/libpq.so.5 /usr/lib64/libpq.so.5
# Create ppradmin user and ppr directory
sudo useradd ppradmin -d "$DEST_DIR" -s /bin/bash
sudo echo Useready1 | passwd ppradmin --stdin
#echo "Enter password for ppradmin user: "
#sudo passwd ppradmin
sudo chown -R ppradmin:ppradmin "$DEST_DIR"
sudo usermod -a -G ppradmin $USER
# ppradmin installation
#sudo cp -r pgsql "$DEST_DIR"
sudo chown -R ppradmin:ppradmin "$DEST_DIR"
echo "export PATH=$PATH:${DEST_DIR}/pgsql/bin" | sudo tee /etc/profile.d/postgresql_ppr.sh
source /etc/profile
#read -rsp "Enter ppradmin user password: " PPRADMIN_PASSWORD
PPRADMIN_PASSWORD=Useready1
sudo echo "$PPRADMIN_PASSWORD" | sudo tee "$DEST_DIR"/pgsql/bin/.pgpass
sudo runuser -u ppradmin -- "$DEST_DIR"/pgsql/bin/initdb -D "$DEST_DIR"/pgsql/data
sudo cp "$DEST_DIR"/services/postgresql_ppr.service /etc/systemd/system
sudo systemctl daemon-reload
sudo systemctl start postgresql_ppr
#sudo systemctl status postgresql_ppr

# Call the configuration script
#sudo cp -r pixelperfect_server "$DEST_DIR"
#sudo cp "$SRC_DIR"/*.sh "$DEST_DIR"
sudo cp "$DEST_DIR"/services/*.service /etc/systemd/system

#Copy BirtOnline Files 

# sudo cp /Y "$DEST_DIR"/pixelperfect_server/birtonline/lib64/* /usr/lib64  add ldlIB
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/etc/* /etc
if [ -d "/etc/fonts" ]
then
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/etc_fonts/* /etc/fonts
else
    sudo mkdir /etc/fonts
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/etc_fonts/* /etc/fonts
fi
if [ -d "/etc/xdg" ] 
then
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/etc_xdg/* /etc/xdg 
else
    sudo mkdir /etc/xdg
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/etc_xdg/* /etc/xdg
fi
if [ -d "/usr/share/bash-completion/completions" ] 
then
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_share_bash-completion_completions/* /usr/share/bash-completion/completions 
else
    sudo mkdir /usr/share/bash-completion/completions
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_share_bash-completion_completions/* /usr/share/bash-completion/completions
fi        

sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/locale/xkeyboard-config.7.gz /usr/share/man/man7/
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/locale/xkeyboard-config.mo /usr/share/locale/en_GB/LC_MESSAGES/
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_bin/* /usr/bin 
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_share/* /usr/share
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_share_themes/* /usr/share/themes
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_share_icons/* /usr/share/icons
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/lib64/gdk-pixbuf-2.0 /usr/lib64


sudo cp -n "$DEST_DIR"/pixelperfect_server/birtonline/apps/python/local_bin/localbin.tar /usr/local/bin
sudo cp -n "$DEST_DIR"/pixelperfect_server/birtonline/apps/python/local_lib/locallib.tar /usr/local/lib
sudo tar -xvf /usr/local/lib/locallib.tar --directory /usr/local/lib
sudo tar -xvf /usr/local/bin/localbin.tar --directory /usr/local/bin
sudo tar -xvf /usr/share/icons/Adwaita.tar --directory /usr/share/icons

sudo cp -R -n "$DEST_DIR"/utils/net-sf-jpam /etc/pam.d 

echo "export PATH=$PATH:${DEST_DIR}/pixelperfect_server/birtonline/libs/usr_bin:/usr/local/bin" | sudo tee -a /etc/profile.d/ppr.sh
source /etc/profile

sudo echo "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/pixelperfect/pixelperfect_server/birtonline/libs/lib64/" | sudo tee -a /etc/profile.d/pprbirt.sh
source /etc/profile


#sudo cp ./*.class "$DEST_DIR"
#sudo cp ./*.jar "$DEST_DIR"
#cd "$DEST_DIR" || exit
sudo chown -R ppradmin:ppradmin "$DEST_DIR"
#./configure_credentials.sh auto

sudo chown -R ppradmin:ppradmin "$DEST_DIR"

sudo systemctl daemon-reload
sudo runuser -u ppradmin -- "$DEST_DIR"/pgsql/bin/psql -U ppradmin -p 8032 -d postgres -a -f "$DEST_DIR"/pixelperfect_server/schema/schema.sql
sudo runuser -u ppradmin -- "$DEST_DIR"/pgsql/bin/psql -U ppradmin -p 8032 -d pixelperfect -a -f "$DEST_DIR"/pixelperfect_server/schema/storage_insert.sql
sudo systemctl start pixel_perfect_clustercontroller pixel_perfect_configuration

sudo rm -rf /usr/local/lib/locallib.tar
sudo rm -rf /usr/local/bin/localbin.tar


{ echo "alias ppr-start='sudo systemctl start pixel_perfect_clustercontroller pixel_perfect_configuration pixel_perfect_api pixel_perfect_engine pixel_perfect_scheduler'";
echo "alias ppr-stop='sudo systemctl stop pixel_perfect_clustercontroller pixel_perfect_configuration pixel_perfect_api pixel_perfect_engine pixel_perfect_scheduler'";
echo "alias ppr-restart='sudo systemctl restart pixel_perfect_clustercontroller pixel_perfect_configuration pixel_perfect_api pixel_perfect_engine pixel_perfect_scheduler'";
echo "alias ppr-status='sudo systemctl status pixel_perfect_clustercontroller pixel_perfect_configuration pixel_perfect_api pixel_perfect_engine pixel_perfect_scheduler'"; 
echo "alias show-logs='tail -f ${DEST_DIR}/pixelperfect_server/pixel_perfect_api/spring.log ${DEST_DIR}/pixelperfect_server/pixel_perfect_engine/spring.log ${DEST_DIR}/pixelperfect_server/pixel_perfect_scheduler/spring.log'"; } >>~/.bashrc
source ~/.bashrc

# Make the rep_configuration file executable
chmod +x "$DEST_DIR"/scripts/rep_configuration.sh

sudo tar -xvf "$DEST_DIR"/pixelperfect_server/birtonline/apps/birt.tar --directory "$DEST_DIR"/pixelperfect_server/birtonline/apps/
# sudo rm -rf "$DEST_DIR"/pixelperfect_server/birtonline/apps/birt.tar


# Generate ssh key 
mkdir -p /opt/pixelperfect/.ssh
sudo chown -R ppradmin:ppradmin "$DEST_DIR"
GENERATE_SSH="ssh-keygen -q -t rsa -N '' -f /opt/pixelperfect/.ssh/id_rsa <<<y >/dev/null 2>&1"
su -s /bin/bash -c "$GENERATE_SSH" ppradmin
sudo chown -R ppradmin:ppradmin "$DEST_DIR"
echo "SSH keys were generated"

SERVICE_STATUS_URL="http://localhost:9096/node-mgmt/service-status"
ACK_URL='http://localhost:9096/node-mgmt/initialize-services'
for i in {1..60}; do
    response=$(curl -s -o /dev/null -w "%{http_code}" $SERVICE_STATUS_URL)
    echo ${response}
    if [[ $response -eq 200 ]] || [[ $response -eq 204 ]]; then
        echo "Check server was successful"
        MY_HOSTNAME=$(hostname)
        MY_IP=$(ip addr show | grep -w inet | grep -v 127.0.0.1 | awk '{ print $2 }' | awk -F '/' '{ print $1 }')
        SERVICE_IDS=("2","3","4","5","6","7")
        echo "{\"hostName\":\"${MY_HOSTNAME}\",\"hostIp\":\"${MY_IP}\",\"serviceId\":\"${SERVICE_IDS}\",\"primaryServer\":\"true\",\"newServer\":\"true\",\"hostAlreadyAdded\":\"false\" }"
        ACK_RESPONSE=$(curl --header "Content-Type: application/json" --request POST --data "{\"hostName\":\"${MY_HOSTNAME}\",\"hostIp\":\"${MY_IP}\",\"serviceId\":\"${SERVICE_IDS}\",\"primaryServer\":\"true\",\"newServer\":\"false\",\"hostAlreadyAdded\":\"false\" }"  ${ACK_URL})
        echo ${ACK_RESPONSE}
        break
    else
        echo "SERVICE_STATUS_URL is not active"
    fi
    sleep 1
done
if [[ $response -ne 200 ]] && [[ $response -ne 204 ]]; then
    echo "Error with configuration service"
fi
echo "Installation complete"
