#!/bin/bash
CUR_PATH=$(pwd)
DEST_DIR="$CUR_PATH"

invoke_manual_config () {
    echo "What would you like to do?"
	echo   "1. Email configuration."
	echo   "2. Tableau configuration."
	echo   "3. Pixel Perfect Services configuration."
	echo   "4. Add public cert to trust store."
	echo   "5. Exit"

	read -rp "Please enter a numeric option from the above:" answer

	if [ "$answer" = "5" ]; then
	    echo Thank you for using script
		exit 0
	elif [ "$answer" = "1" ]; then
		create_mail_config_file
	elif [ "$answer" = "2" ]; then
		create_tableau_config_file
	elif [ "$answer" = "3" ]; then
		configure_pixel_perfect_services "$@"
	elif [ "$answer" = "4" ]; then
		read -rp "Enter the path to the public certificate" CERT_FILE
		add_public_cert_to_trust_store "$CERT_FILE"
	else
        exit 0
    fi
}

create_mail_config_file() {
    echo SMTP Mail Configuration: This will used to sending generated report: 
	echo   1. SMTP server configuration.
	echo   2. SMTP Relay Service configuration.
    echo   3. Exit
	read -rp "Please enter a numeric option from the above:" SMTP_MODE
	if [ "$SMTP_MODE" = "2" ]; then
		create_smtp_mail_relay_config
	else
		create_smtp_mail_config
    fi
}

create_smtp_mail_config() {
    read -rp "Enter e-mail Address:" EMAIL
	read -rsp "Enter e-mail password:" EMAILPASSWORD
	echo "Password encrypted successfully"
    read -rp "Enter SMTP Host (ex: smtp.office365.com):" SMTP
    read -rp "Is this Secure mail? (T/F):" SECURE
    SECURE_VAL=false
    if [ "$SECURE" = "T" ]; then 
        read -rp "Set Type (ex: STARTTLS):" TYPE
        SECURE_VAL=true
    fi
    read -rp "Enter Port(ex: 587):" PORT
    ENCRYPTED_PASSWORD=$(java Encrypt "$EMAILPASSWORD")
    echo mail.password="$ENCRYPTED_PASSWORD" | sudo tee mail.properties
    { echo mail.email="$EMAIL";
    echo mail.domain="$SMTP";
    echo mail.secure="$SECURE_VAL";
    echo mail.port="$PORT";
    echo mail.type="$TYPE"; } | sudo tee -a mail.properties
	sudo mv mail.properties pixelperfect_server/configuration
	echo "Moved configuration file to configuration folder"
}

create_smtp_mail_relay_config() {
    read -rp "SMTP relay host (ex: smtp.office365.com)" SMTP
    read -rp "Is this Secure mail? (T/F):" SECURE
    SECURE_VAL=false
    if [ "$SECURE" = "T" ]; then 
        read -rp "Set Type (ex: STARTTLS):" TYPE
        SECURE_VAL=true
    fi
	read -rp "Enter From address if required (Leave blank if not required): " FROM_ADDRESS
    read -rp "Enter Port(ex: 587):" PORT
    echo mail.password= | sudo tee mail.properties
    { echo mail.email="$FROM_ADDRESS";
    echo mail.domain="$SMTP";
    echo mail.secure="$SECURE_VAL";
    echo mail.port="$PORT";
    echo mail.type="$TYPE";} | sudo tee -a mail.properties
	sudo mv mail.properties pixelperfect_server/configuration
	echo "Moved configuration file to configuration folder"
}

create_tableau_config_file() {
    echo Tableau Credentials Configuration
	read -rp "Tableau administrative UserName:" USER
	read -rsp "Tableau administrative Password:" TABLEAUPASSWORD
    ENCRYPTED_PASSWORD=$(java Encrypt "$TABLEAUPASSWORD")
	echo "Password encrypted successfully"
    read -rp "Tableau Server URL (URL should end with /):" SERVER
	echo tableau.server="$SERVER"| sudo tee tableau.properties
	{ echo tableau.apiversion=3.4;
	echo tableau.username="$USER";
	echo tableau.password="$ENCRYPTED_PASSWORD"; } | sudo tee -a tableau.properties
	sudo mv tableau.properties pixelperfect_server/configuration
	echo "Moved configuration file to configuration folder"
}

configure_pixel_perfect_services() {
    if [ "$1" = "auto" ]; then
		CONFIG_OPTION=1
	else
		echo   1. All Services Configuration.
		echo   2. PixelPerfectAPI Configuration.
		echo   3. PixelPerfectScheduler Configuration.
		echo   4. PixelPerfectEngine Configuration.
		echo   5. Webfolio Configuration.
		echo   6. Trex File Configuration.
		read -rp "Please enter a numeric option from the above:" CONFIG_OPTION
	fi
    PGPASSWORD="Useready1"
	if [ -f /opt/ppr/pgsql/bin/.pgpass  ]; then
		PGPASSWORD=$(cat /opt/ppr/pgsql/bin/.pgpass)
	else
		#read -rsp "Please enter postgres password:" PGPASSWORD
		#echo "Password captured"
	fi
	
	echo Database Password from Environment: "$PGPASSWORD"
	#read -rp "Enter the hostname (FQDN): " SERVER_HOST
    ENCRYPTED_DB_PASSWORD=$(java -jar PasswordUtility.jar encrypt "$PGPASSWORD")
	#read -rp "Enter storage type - local or cloud: " STORAGE
	STORAGE=local
	SECURE_VAL=false
    TEMPLATES_BUCKET=templates-bucket
    REPORTS_BUCKET=reports-bucket
    if [ "$STORAGE" = "cloud" ]; then 
        read -rp "Enter the bucket path for storing report templates eg. - ppsrvtest/rpt-designs/ : " TEMPLATES_BUCKET
		read -rp "Enter the bucket path for storing output reports eg. - ppsrvtest/rpt-designs/ : " REPORTS_BUCKET
    else
		STORAGE=local
	fi

	echo "Encrypted Passsword: " "$ENCRYPTED_DB_PASSWORD"
	ENCRYPTED_DB_PASSWORD="ENC(${ENCRYPTED_DB_PASSWORD})"
	echo "$CUR_PATH" "$SERVER_HOST" "$TEMPLATES_BUCKET" "$REPORTS_BUCKET" "$ENCRYPTED_DB_PASSWORD"
	
	if [ "$CONFIG_OPTION" = "1" ]; then
		configure_pixel_perfect_api "$CUR_PATH" "$ENCRYPTED_DB_PASSWORD" "$STORAGE" "$TEMPLATES_BUCKET" "$REPORTS_BUCKET"
	
		configure_pixel_perfect_scheduler "$CUR_PATH" "$ENCRYPTED_DB_PASSWORD"
		
		configure_pixel_perfect_engine "$CUR_PATH" "$SERVER_HOST" "$ENCRYPTED_DB_PASSWORD" "$STORAGE" "$TEMPLATES_BUCKET" "$REPORTS_BUCKET"

		#configure_webfolio_properties "$SERVER_HOST" "$STORAGE"

		#configure_trex_file "$SERVER_HOST"
		sudo cp PixelPerfectHybrid.trex pixelperfect_server/webfolio
	elif [ "$CONFIG_OPTION" = "2" ]; then
		configure_pixel_perfect_api "$CUR_PATH" "$ENCRYPTED_DB_PASSWORD" "$STORAGE" "$TEMPLATES_BUCKET" "$REPORTS_BUCKET"
	elif [ "$CONFIG_OPTION" = "3" ]; then
		configure_pixel_perfect_scheduler "$CUR_PATH" "$ENCRYPTED_DB_PASSWORD"
	elif [ "$CONFIG_OPTION" = "4" ]; then
		configure_pixel_perfect_engine "$CUR_PATH" "$SERVER_HOST" "$ENCRYPTED_DB_PASSWORD" "$STORAGE" "$TEMPLATES_BUCKET" "$REPORTS_BUCKET"
	elif [ "$CONFIG_OPTION" = "5" ]; then
		configure_webfolio_properties "$SERVER_HOST" "$STORAGE"
	elif [ "$CONFIG_OPTION" = "6" ]; then
		configure_trex_file "$SERVER_HOST"
		sudo cp PixelPerfectHybrid.trex pixelperfect_server/webfolio
	fi
}

configure_pixel_perfect_api() {
    #read -rp "Enter SFTP Host name/address: " SFTP_HOST
	#read -rp "Enter SFTP Port (22): " SFTP_PORT

	#read -rsp "Enter a password for JWT Tokens: " JWT_SECRET
	JWT_SECRET=Useready1
    ENCRYPTED_JWT_SECRET=$(java -jar PasswordUtility.jar encrypt "$JWT_SECRET")
	ENCRYPTED_JWT_SECRET="ENC(${ENCRYPTED_JWT_SECRET})"
	echo "Password encryted successfully"
	#read -rp "Enter the key alias for JKS: " KEY_ALIAS
    KEY_ALIAS=test
    #read -rsp "Enter the certificate password: " JKS_PASSWORD
	JKS_PASSWORD=test
	ENCRYPTED_JKS_PASSWORD=$(java -jar PasswordUtility.jar encrypt "$JKS_PASSWORD")
	ENCRYPTED_JKS_PASSWORD="ENC(${ENCRYPTED_JKS_PASSWORD})"
	#echo "Password encryted successfully"

	# Write the properties
	echo \#==================================================================================================================================================|sudo tee pixelperfect_server/pixel_perfect_api/application.properties
	{ echo \#		Applications Server config;
	echo \#==================================================================================================================================================;
	echo spring.application.name=PixelPerfectAPIService;
	echo server.port=443;
	echo pixelperfectserver.recent.files.limit=10;
	echo mail.config.relative.path="$1"/pixelperfect_server/configuration/mail.properties;
	echo \#==================================================================================================================================================;
	echo \#						Tableau Properties;
	echo \#==================================================================================================================================================;
	echo tableau.configuration.relative.path ="$1"/pixelperfect_server/configuration/tableau.properties;
	echo reports.relative.path="$1"/pixelperfect_server/reports;
	echo jars.relative.path="$1"/pixelperfect_server/reports/jars;
	echo output.relative.path="$1"/output-files/;
	echo folio.relative.path="$1"/pixelperfect_server/webfolio/;
	echo ;
	echo \#==================================================================================================================================================;
	echo \#								Server Configurations									 	 ;
	echo \#==================================================================================================================================================;
	echo pixel.perfect.server.scheduler.endpoint=http://localhost:8098/api/v1/scheduler;
	echo pixel.perfect.server.report.engine=http://localhost:8099/;
	echo \#==================================================================================================================================================;
	echo \#								Logging									 	 ;
	echo \#==================================================================================================================================================;
	echo logging.level.root= WARN;
	echo logging.level.com.useready= DEBUG;
	echo logging.file.path = "$1"/pixelperfect_server/logs/pixel_perfect_api;
	echo "logging.pattern.file= %d{yyyy-MMM-dd HH:mm:ss.SSS} %-5level [%thread] %logger{15} - %msg%n";
	echo "logging.pattern.console= %d{yyyy-MMM-dd HH:mm:ss.SSS} %-5level [%thread] %logger{15} - %msg%n";
	echo \# ===============================;
	echo \# = DATA SOURCE;
	echo \# ===============================;
	echo \# Set here configurations for the database connection;
	echo spring.jpa.properties.hibernate.dialect = org.hibernate.dialect.PostgreSQL9Dialect;
	echo spring.jpa.properties.hibernate.jdbc.lob.non_contextual_creation=true;
	echo spring.jpa.hibernate.ddl-auto=none;
	echo spring.jpa.hibernate.show-sql=true;
	echo spring.jpa.hibernate.naming-strategy=org.hibernate.cfg.DefaultNamingStrategy;
	echo \#setting current schema name as below;
	echo spring.jpa.properties.hibernate.default_schema=ppserver;
	echo spring.datasource.driver-class-name=org.postgresql.Driver;
	echo spring.datasource.url=jdbc:postgresql://localhost:8032/pixelperfect;
	echo spring.datasource.username=ppradmin;
	echo spring.datasource.password="$2";
	echo \#spring.datasource.initialization-mode=always;
	echo \#spring.datasource.initialize=true;
	echo spring.datasource.schema=classpath:/schema.sql;
	echo spring.datasource.continue-on-error=true;
	echo \#==================================================================================================================================================;
	echo \#= Enable HTTPS;
	echo \#==================================================================================================================================================;
	echo server.ssl.enabled = true;
	echo \# The format used for the keystore ;
	echo server.ssl.key-store-type = PKCS12;
	echo \# The path to the keystore containing the certificate;
	echo server.ssl.key-store="$1"/pixelperfect_server/configuration/out.jks;
	echo \#server.ssl.key-store=classpath:selfsigned.jks;
	echo \# The password used to generate the certificate;
	echo server.ssl.key-store-password = "$ENCRYPTED_JKS_PASSWORD";
	echo \# The alias mapped to the certificate;
	echo server.ssl.key-alias = "$KEY_ALIAS";
	echo \#==================================================================================================================================================;
	echo \#= S3 bucket config;
	echo \#==================================================================================================================================================;
	echo \#Bucket name to save generated reports ;
	echo output.reports.bucket = "$5";
	echo \#Bucket name for Templates and jars;
	echo report.templates.bucket = "$4";
	echo \#==================================================================================================================================================;
	echo \#= Storage Enviroment variable local OR S3\(cloud\);
	echo \#= key value will be local/cloud;
	echo \#==================================================================================================================================================;
	echo storage.environment.type = "$3";
	echo \#==================================================================================================================================================;
	echo \#= JWT configuration;
	echo \#==================================================================================================================================================;
	echo jwt.secret="$ENCRYPTED_JWT_SECRET";
	echo ;
	echo \#==================================================================================================================================================;
	echo \#= License Configuration;
	echo \#==================================================================================================================================================;
	echo pixel.perfect.server.license.file="$1"/pixelperfect_server/configuration/qlm-license.xml;
	echo pixel.perfect.server.license.key.file="$1"/pixelperfect_server/configuration/license-server-public-key.xml;
	echo ;
	echo \# Enable multipart uploads;
	echo spring.servlet.multipart.enabled=true;
	echo \# Threshold after which files are written to disk.;
	echo spring.servlet.multipart.file-size-threshold=2KB;
	echo \# Max file size.;
	echo spring.servlet.multipart.max-file-size=200MB;
	echo \# Max Request Size;
	echo spring.servlet.multipart.max-request-size=400MB;
	echo ;
	echo \# Set below prop to true to update the jar path in the report template automatically after uploading, false otherwise;
	echo reports.jarpath.update = true;
	echo ;
	echo \# Set below prop to true to delete the jar dependencies \(Excluding jackson-\*.jar files\) if the report template is deleted;
	echo reports.jars.delete = true;
	echo ;
	echo \# SFTP Configuration;
	echo sftp.server.host = "$SFTP_HOST";
	echo sftp.server.port = "$SFTP_PORT";
	echo sftp.server.adminUser = ;
	echo ;
	echo \# Path to upload images for Email Signature;
	echo image.upload.path = "$1"/pixelperfect_server/webfolio/assets;
	echo ;
	echo \# URL prefix for output directory and folio build;
	echo output.path.prefix=outputFiles;
	echo folio.path.prefix=home;
	echo additional.connector=true;
	echo http.port=80;
	echo ;
	echo \#==================================================================================================================================================; } |sudo tee -a pixelperfect_server/pixel_perfect_api/application.properties
}

configure_pixel_perfect_scheduler() {
	# Write the properties
	echo \#==================================================================================================================================================| sudo tee pixelperfect_server/pixel_perfect_scheduler/application.properties
	{ echo \#		Applications Server config;
	echo \#==================================================================================================================================================;
	echo server.port=8098;
	echo spring.application.name=PixelPerfectSchedulerService;
	echo spring.jackson.default-property-inclusion: NON_NULL;
	echo adminToken=userready1$;
	echo \#==================================================================================================================================================;
	echo \#		Report Engine config;
	echo \#==================================================================================================================================================;
	echo pixelperfectserver.report.engine.path=http://localhost:8099/;
	echo \#==================================================================================================================================================;
	echo \#								Logging									 	 ;
	echo \#==================================================================================================================================================;
	echo logging.level.root= WARN;
	echo logging.level.com.useready= DEBUG;
	echo logging.path = "$1"/pixelperfect_server/logs/pixel_perfect_scheduler;
	echo "logging.pattern.file= %d{yyyy-MMM-dd HH:mm:ss.SSS} %-5level [%thread] %logger{15} - %msg%n";
	echo "logging.pattern.console= %d{yyyy-MMM-dd HH:mm:ss.SSS} %-5level [%thread] %logger{15} - %msg%n";
	echo \# ===============================;
	echo \# = DATA SOURCE;
	echo \# ===============================;
	echo \# Set here configurations for the database connection;
	echo spring.datasource.url=jdbc:postgresql://localhost:8032/pixelperfect;
	echo spring.datasource.username=ppradmin;
	echo spring.datasource.password="$2";
	echo spring.datasource.driver-class-name=org.postgresql.Driver;
	echo \# Keep the connection alive if idle for a long time \(needed in production\);
	echo spring.datasource.testWhileIdle=true;
	echo spring.datasource.validationQuery=SELECT 1;
	echo \# ===============================;
	echo \# = JPA / HIBERNATE;
	echo \# ===============================;
	echo \# Show or not log for each sql query;
	echo spring.jpa.show-sql=true;
	echo \# Hibernate ddl auto \(create, create-drop, update\): with \"create-drop\" the database;
	echo \# schema will be automatically created afresh for every start of application;
	echo \# spring.jpa.hibernate.ddl-auto=create-drop;
	echo \# Naming strategy;
	echo spring.jpa.hibernate.naming.implicit-strategy=org.hibernate.boot.model.naming.ImplicitNamingStrategyLegacyHbmImpl;
	echo spring.jpa.hibernate.naming.physical-strategy=org.springframework.boot.orm.jpa.hibernate.SpringPhysicalNamingStrategy;
	echo \# Allows Hibernate to generate SQL optimized for a particular DBMS;
	echo spring.jpa.properties.hibernate.dialect=org.hibernate.dialect.PostgreSQLDialect;
	echo spring.jpa.properties.hibernate.jdbc.lob.non_contextual_creation=true;
	echo spring.jpa.database-platform=org.hibernate.dialect.PostgreSQL9Dialect;
	echo spring.jpa.properties.hibernate.default_schema=ppserver;
	echo \#==================================================================================================================================================; } | sudo tee -a pixelperfect_server/pixel_perfect_scheduler/application.properties
}

configure_pixel_perfect_engine() {
	# Write the properties
	echo \#==================================================================================================================================================| sudo tee pixelperfect_server/pixel_perfect_engine/application.properties
	{ echo \#		Applications Server config;
	echo \#==================================================================================================================================================;
	echo \# Service name;
	echo spring.application.name=report-engine;
	echo \# server port - server entry point;
	echo server.port=8099;
	echo reports.relative.path="$1"/pixelperfect_server/reports;
	echo jars.relative.path="$1"/pixelperfect_server/reports/jars;
	echo output.relative.path="$1"/output-files/;
	echo \#mail end point;
	echo pixel.perfect.server.api.mail.endpoint=http://localhost/mail/send/;
	echo \#get token url;
	echo pixel.perfect.server.api.jwttoken.endpoint=http://localhost/pps/config/user-info;
	echo pixel.perfect.server.api.decrypter.endpoint=http://localhost/pps/general/check;
	echo \# SFTP end point;
	echo pixel.perfect.server.api.sftp.endpoint=http://localhost/pps/sftp/upload;
	echo pixel.perfect.server.api.adminToken=userready1$;
	echo \#==================================================================================================================================================;
	echo \#						Tableau Properties;
	echo \#==================================================================================================================================================;
	echo tableau.configuration.relative.path = "$1"/pixelperfect_server/configuration/tableau.properties;
	echo \#==================================================================================================================================================;
	echo \#;
	echo \#==================================================================================================================================================;
	echo spring.datasource.driver-class-name=org.postgresql.Driver;
	echo spring.datasource.jdbc-url=jdbc:postgresql://localhost:8032/pixelperfect;
	echo spring.datasource.username=ppradmin;
	echo spring.datasource.password="$3";
	echo spring.jpa.open-in-view=false;
	echo \#==================================================================================================================================================;
	echo \#								Logging									 	 ;
	echo \#==================================================================================================================================================;
	echo logging.level.root= WARN;
	echo logging.level.com.useready= DEBUG;
	echo logging.file.path ="$1"/pixelperfect_server/logs/pixel_perfect_engine;
	echo "logging.pattern.file= %d{yyyy-MMM-dd HH:mm:ss.SSS} %-5level [%thread] %logger{15} - %msg%n";
	echo "logging.pattern.console= %d{yyyy-MMM-dd HH:mm:ss.SSS} %-5level [%thread] %logger{15} - %msg%n";
	echo \#==================================================================================================================================================;
	echo \#= Enable HTTPS;
	echo \#==================================================================================================================================================;
	echo \#server.ssl.enabled=true;
	echo \# The format used for the keystore ;
	echo \#server.ssl.key-store-type=PKCS12;
	echo \# The path to the keystore containing the certificate;
	echo \#server.ssl.key-store=C://Users//saikrishnam//Downloads//ssl//useready.com.jks;
	echo \#server.ssl.key-store=classpath:selfsigned.jks;
	echo \# The password used to generate the certificate;
	echo \#server.ssl.key-store-password=PixelPerfect#12;
	echo \# The alias mapped to the certificate;
	echo \#server.ssl.key-alias=pixel-perfect-server-cert;
	echo \#==================================================================================================================================================;
	echo \#= S3 bucket config;
	echo \#==================================================================================================================================================;
	echo \#Bucket name to save generated reports ;
	echo output.reports.bucket = "$6";
	echo \#Bucket name for Templates and jars;
	echo report.templates.bucket = "$5";
	echo \#==================================================================================================================================================;
	echo \#= Storage Enviroment variable local OR S3\(cloud\);
	echo \#= key value will be local/cloud;
	echo \#==================================================================================================================================================;
	echo storage.environment.type = "$4";
	echo \#==================================================================================================================================================;
	echo \#= Tableau Data Settings;
	echo \#==================================================================================================================================================;
	echo tableau.data.log = false;
	echo \# Separate the columns to be excluded using comma. Enclose the column name in double quotes ;
	echo \# if column name contains a comma - E.g- \"State,Region\",Country - \"State,Region\" is a single column ;
	echo \# and Country is second column;
	echo tableau.data.excludedColumns = AsUser;
	echo email.file.maxSize=20;
	echo push.to.sftp.for.large.files=true;
	echo "sftp.path.placeholder=\\\\{sftp-path\\\\}";
	echo run-now.reports.in.parallel=true;
	echo email.signature.image=https://"$2"/home/logo.png;
	echo tableau.data.decryption = false;
	echo tableau.decryption.key.path = "$1"/pixelperfect_server/configuration/tableau.key;
	echo tableau.data.encryptedColumns = EncryptedProfit;
	echo ;
	echo tableau.data.delimiter = ,;
	echo "tableau.data.quote = \"";
	echo "max.concurrent.reports = 10";
	echo \#==================================================================================================================================================; } | sudo tee -a pixelperfect_server/pixel_perfect_engine/application.properties
}


configure_webfolio_properties() {
    echo "$1" "$2"
	if [ "$2" = "cloud" ]; then
		STORAGE_TYPE=AWS_S3
	elif [ "$2" = "local" ];then
		STORAGE_TYPE=Local
	fi
	echo Storage: "$STORAGE_TYPE"
	echo // deploymentType value will be \"Local\" for local File Storage System and \"AWS_S3\" for file storage in S3 bucket| sudo tee pixelperfect_server/webfolio/properties.js
	{ echo var Configs = \{;
	echo 	disableServerComponent : false,;
	echo 	host: \"https://"$1"\",;
	echo 	hostName : \"https://"$1"/home/\",;
	echo 	deploymentType: \"$STORAGE_TYPE\",        ;
	echo 	outputFileName: \"outputFiles\",   // FolderName to store Reports Generated in Local Machine ;
	echo 	emailSignatureImage: \"https://"$1"/home/logo.png\",;
	echo 	hideMailComposition : false;
	echo \};
	echo ; } | sudo tee -a pixelperfect_server/webfolio/properties.js
}

configure_trex_file() {
	echo \<?xml version=\"1.0\" encoding=\"utf-8\"?\>|sudo tee PixelPerfectHybrid.trex
	{ echo \<manifest manifest-version=\"0.1\" xmlns=\"http://www.tableau.com/xml/extension_manifest\"\>;
	echo \<dashboard-extension id=\"com.tableau.extensions.samples.tabeppr\" extension-version=\"2021.1.2\"\>;
	echo 	\<default-locale\>en_US\</default-locale\>;
	echo 	\<name resource-id=\"name\"/\>;
	echo 	\<description\>Pixel Perfect Server\</description\>;
	echo 	\<author name=\"Team USEReady\" email=\"contact@useready.com\" organization=\"USEReady\" website=\"https://www.useready.com/pixel-perfect/\"/\>;
	echo 	\<min-api-version\>0.9\</min-api-version\>;
	echo 	\<source-location\>;
	echo 	\<url\>https://"$1"/home/indextabe.html\</url\>;
	echo 	\</source-location\>;
	echo 	\<icon\>iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAABHNCSVQICAgifAhkiAAAAAlwSFlzAAALEwAACxMBAJqcGAAAAlhJREFUOI2Nkt9vy1EYh5/3bbsvRSySCZbIxI+ZCKsN2TKtSFyIrV2WuRCJuBiJWxfuxCVXbvwFgiEtposgLFJElnbU1SxIZIIRJDKTrdu+53Uhra4mce7Oe57Pcz7JOULFisViwZ+29LAzOSjQYDgz1ZcCvWuXV11MJpN+OS/lm6179teqH0yDqxPTCyKSA8DcDsyOmOprnCaeP7459pdgy969i0LTC3IO/RQMyoHcQN+3cnljW3dNifC47qDaK3g7BwdTkwBaBELT4ZPOUVWgKl4ZBnjxJPUlMDnTDrp0pmr6RHFeEjjcUUXPDGeSEwDN0Xg8sivxMhJNjGzbHd8PkM3eHRfkrBM5NkcQaY2vUnTlrDIA0NoaX+KLXFFlowr14tvVpqb2MICzmQcKqxvbumv+NAhZGCCIPwEw6QWXKYRL/VUXO0+rAUJiPwAk5MIlgVfwPjjHLCL1APmHN94ZdqeYN+NW/mn6I4BvwQYchcLnwFhJMDiYmlRxAzjpKWZkYkUCcZ2I61wi37tLbYyjiN0fHk5Oz3nGSLSzBbNHCF35R7f6K1/hN9PRhek11FrymfQQQKB4+Gl05P2qNRtmETlXW7e+b2z01dfycGNbfFMAbqNyKp9Jp4rzOT8RYFs0njJkc2iqsCObvTsOsDWWqA5C1uFy+Uz/oXJeKwVT4h0RmPUXhi79vuC0Ku6yOffTK3g9lfxfDQAisY516sg5kfOCiJk7HoLt2cf9b/9LANAc7dznm98PagG1fUOZ9IP5uMB8Q4CPoyNvausapkTt3rNMuvdf3C/o6+czhtdwmwAAAABJRU5ErkJggg==\</icon\>;
	echo 	\<context-menu\>;
	echo 	\<configure-context-menu-item /\>;
	echo 	\</context-menu\>;
	echo \</dashboard-extension\>;
	echo \<resources\>;
	echo 	\<resource id=\"name\"\>;
	echo 	\<text locale=\"en_US\"\>Pixel Perfect Server-Webfolio\</text\>;
	echo 	\</resource\>;
	echo \</resources\>;
	echo \</manifest\>;
	echo ; } | sudo tee -a PixelPerfectHybrid.trex
}

add_public_cert_to_trust_store() {
	# Add public certificate to trust store
	if [ -f "$1" ]; then
		sudo runuser -u ppradmin -- "$DEST_DIR"/java-se-8u41-ri/bin/keytool -import -trustcacerts -alias pixelperfect -file "$1" -keystore "$DEST_DIR"/java-se-8u41-ri/jre/lib/security/cacerts
	else
		RED='\033[0;31m'
		NC='\033[0m' # No Color
		echo -e "${RED}Public certificate file for Tableau needed for REST API connection, Please copy cert.pem file to this directory and re-install${NC}"
	fi
}

if [ "$1" = "auto" ]; then
	echo Initializing Pixel Perfect Configurations...
	#create_tableau_config_file
	
	#create_mail_config_file

	configure_pixel_perfect_services "$@"

	#read -rp "Enter the path to the public certificate" CERT_FILE
	#add_public_cert_to_trust_store "$CERT_FILE"
	sudo chown -R ppradmin:ppradmin /var/pixelperfect
else
	invoke_manual_config "$@"
	sudo chown -R ppradmin:ppradmin /var/pixelperfect
fi