'use strict';

/**
 * TABE Dialog 
 * 
 * This is the popup extension portion of the TABE pixel perfect extension, please see
 * apptabe.js in addition to this for context.  This extension is 
 * responsible for collecting configuration settings from the user and communicating
 * that info back to the parent extension.
 * 
 * This sample demonstrates two ways to do that:
 *   1) The suggested and most common method is to store the information 
 *      via the settings namespace.  The parent can subscribe to notifications when
 *      the settings are updated, and collect the new info accordingly.
 *   2) The popup extension can receive and send a string payload via the open 
 *      and close payloads of initializeDialogAsync and closeDialog methods.  This is useful
 *      for information that does not need to be persisted into settings.
 */

// Wrap everything in an anonymous function to avoid polluting the global namespace
(function () {
	/**
	 * This extension collects the IDs of each datasource the user is interested in
	 * and stores this information in settings when the popup is closed.
	 */
	var OutputFormatList = [];
	var ReportNameList = [];
	var DataSourceList = [];
	var ImageSourceList = [];
	var dataOptions = [{key: 'summaryData', value: 'Summary Data', isSummaryData: true}, {key: 'fullData', value: 'Full Data', isSummaryData: false}];
	//OutputFormatList = ['PDF','HTML','XLSX','DOCX','PPT'];

	var parameterListSettingsKey = 'selectedParameters';
	var outputFormatSettingsKey = 'outputFormat';
	var reportNameSettingsKey = 'reportName';
	var dataSourceSheetSettingsKey = 'dataSourceSheet';
	var ImageSourceSheetSettingsKey = 'ImageSourceSheet';
	var reportingUrlSettingsKey = 'reportingUrl';
	var reportingApplicationSettingsKey = 'reportingApplication';
	var authenticationSettingsKey = 'authentication';
	var dataOptionKey = 'dataOption';

	var userName = "";

	var adminSectionShown = false;//Hide adminSection by default

	var paramData = [];
	var paramDataString = "";
	var outputFormatInit = "";
	var reportNameInit = "";
	var dataSourceSheetInit = "";
	var ImageSourceSheetInit = "";
	var reportingUrlInit = "";
	var reportingApplicationInit = "";
	var authenticationInit = "";
	var sampleData = "";
	var dataOption = "summaryData";
	let workbookUrl = "";
	//var urlBase = "https://devdemotableau.useready.com:8443/PixelPerfect_Test/run";
	var urlBase = "../run";

	var test = $.getJSON("outputFormat.json", function (data) {
		OutputFormatList = data;
	});

	//var report = $.getJSON("reportName.json",function(data){
	//	ReportNameList = data;
	//});


	//var datasource = $.getJSON("dataSource.json",function(data){
	//	DataSourceList = data;
	//});
	function encodeData(postData) {
		let encodedPostData = '';
		Object.keys(postData).forEach((field) => {
			encodedPostData += `${encodeURIComponent(field)}=${encodeURIComponent(postData[field])}&`;
		});
		if (encodedPostData.length) {
			encodedPostData = encodedPostData.slice(0, encodedPostData.length - 1);
		}
		return encodedPostData;
	}

	function httpRequest(url, options) {
		return new Promise(function(resolve, reject) {
			fetch(url, options).then(function(response) {
				resolve(response);
			}).catch(function(error) {
				reject(error);
			});
		});
	}

	$(document).ready(function () {
		//Wireup methods.
		$('#closeButton').click(closeDialog);
		$('#showHideAdminConfig').click(toggleAdminArea);
		$("#jarBtn").click(generateJar);
		// The only difference between an extension in a dashboard and an extension 
		// running in a popup is that the popup extension must use the method
		// initializeDialogAsync instead of initializeAsync for initialization.
		// This has no affect on the development of the extension but is used internally.
		tableau.extensions.initializeDialogAsync().then(function (openPayload) {
			// The openPayload sent from the parent extension in this sample is the 
			// default time interval for the refreshes.  This could alternatively be stored
			// in settings, but is used in this sample to demonstrate open and close payloads.
			console.log('Open Payload: ' + openPayload);

			var openPayloadArray = JSON.parse(openPayload);
			//console.log("openPayloadArray : " + openPayloadArray);
			//console.log(openPayloadArray[0].paramData);
			//paramData = JSON.parse(openPayloadArray[0].paramData);
			//console.log("paramData : " + paramData);
			paramDataString = openPayloadArray[0].paramData;
			console.log("paramDataString : " + paramDataString);

			DataSourceList = JSON.parse(openPayloadArray[0].worksheets);
			console.log("DataSourceList : " + DataSourceList);

			ImageSourceList = JSON.parse(openPayloadArray[0].worksheets);
			console.log("ImageSourceList : " + ImageSourceList);


			ReportNameList = JSON.parse(openPayloadArray[0].reports);
			console.log("ReportNameList : " + ReportNameList);

			userName = openPayloadArray[0].userName;
			console.log("userName : " + userName);

			sampleData = openPayloadArray[0].sampleData;
			console.log("sampleData : " + sampleData);

			workbookUrl = openPayloadArray[0].workbookUrl;
			console.log("Workbook : " + workbookUrl);

			if (paramDataString == '') //instead of openPayload used paramDataString
			{
				var outputFormatTD = '';
				var i;
				outputFormatTD = '<div>';
				outputFormatTD += '<select id="outputFormatDDS"  class="f1w4izzo">';
				for (i = 0; i < OutputFormatList.length; i++) {
					outputFormatTD += ('<option>' + OutputFormatList[i].name + '</option>');
				}
				outputFormatTD += '</select>';
				outputFormatTD += '</div>';
				document.getElementById("outputFormatDiv").innerHTML = outputFormatTD;

				if (userName == '') {
					var reportNameTD = '';
					var j;
					reportNameTD = '<div>';
					reportNameTD += '<select id="reportNameDDS"  class="f1w4izzo">';
					reportNameTD += '<option>' + "Sign in to the server to get the list of reports" + '</option>';
					reportNameTD += '</select>';
					reportNameTD += '</div>';
					document.getElementById("reportNameDiv").innerHTML = reportNameTD;
				}
				else {
					var reportNameTD = '';
					var j;
					reportNameTD = '<div>';
					reportNameTD += '<select id="reportNameDDS"  class="f1w4izzo">';
					for (j = 0; j < ReportNameList.length; j++) {
						reportNameTD += ('<option>' + ReportNameList[j] + '</option>');
					}
					reportNameTD += '</select>';
					reportNameTD += '</div>';
					document.getElementById("reportNameDiv").innerHTML = reportNameTD;
				}

				let dataOptionTD = '<div>';
				dataOptionTD += '<select id="dataOptionDDS"  class="f1w4izzo">';
				for (let i = 0; i < dataOptions.length; i++) {
					dataOptionTD += ('<option>' + dataOptions[i].value + '</option>');
				}
				dataOptionTD += '</select>';
				dataOptionTD += '</div>';
				document.getElementById("dataOptionDiv").innerHTML = dataOptionTD;

				var dataSourceTD = '';
				var k;
				dataSourceTD = '<div>';
				dataSourceTD += '<select id="dataSourceSheetDDS"  multiple="multiple" class="f1w4izzo">';
				for (k = 0; k < DataSourceList.length; k++) {
					dataSourceTD += ('<option>' + DataSourceList[k] + '</option>');
				}
				dataSourceTD += '</select>';
				dataSourceTD += '</div>';
				document.getElementById("dataSourceDiv").innerHTML = dataSourceTD;

				var ImageSourceTD = '';
				var p;
				ImageSourceTD = '<div>';
				ImageSourceTD += '<select id="ImageSourceSheetDDS" class="f1w4izzo" multiple="multiple">';
				for (p = 0; p < ImageSourceList.length; p++) {
					ImageSourceTD += ('<option>' + ImageSourceList[p] + '</option>');
				}
				ImageSourceTD += '</select>';
				ImageSourceTD += '</div>';
				document.getElementById("ImageSourceDiv").innerHTML = ImageSourceTD;
				//$('#ImageSourceSheetDDS').multiselect();

				$("#dataSourceSheetDDS").multiselect();
				$("#ImageSourceSheetDDS").multiselect();
				/*{
					buttonWidth: "130px",
					maxHeight: 400,
					enableClickableOptGroups: true,
					enableCollapsibleOptGroups: true,
					enableFiltering: true,
					filterPlaceholder: "Search for",
					includeSelectAllOption: true,
					enableCaseInsensitiveFiltering: true,
					selectAllJustVisible: false,
					selectAllText: "Select All",
					nSelectedText: " selected items",
					allSelectedText: "All selected items",
					nonSelectedText: "No items selected",
				  });*/

			}
			else {
				//Get initialized or configured values
				paramData = JSON.parse(openPayloadArray[0].paramData);
				//console.log('paramData : ' + paramData);
				outputFormatInit = paramData[0];
				reportNameInit = paramData[1];
				dataSourceSheetInit = paramData[2];
				ImageSourceSheetInit = paramData[3];
				reportingUrlInit = paramData[4];
				reportingApplicationInit = paramData[5];
				authenticationInit = paramData[6];
				dataOption = paramData[7];
				//console.log(openPayload);
				//outputFormatInit = openPayload;
				//console.log(OutputFormatList);

				var outputFormatTD = '';
				var i;
				outputFormatTD = '<div>';
				outputFormatTD += '<select id="outputFormatDDS"  class="f1w4izzo">';
				for (i = 0; i < OutputFormatList.length; i++) {
					if (OutputFormatList[i].name == outputFormatInit)
						outputFormatTD += ('<option selected>' + OutputFormatList[i].name + '</option>');
					else
						outputFormatTD += ('<option>' + OutputFormatList[i].name + '</option>');
				}
				outputFormatTD += '</select>';
				outputFormatTD += '</div>';
				document.getElementById("outputFormatDiv").innerHTML = outputFormatTD;

				if (userName == '') {
					var reportNameTD = '';
					var j;
					reportNameTD = '<div>';
					reportNameTD += '<select id="reportNameDDS"  class="f1w4izzo">';
					reportNameTD += '<option>' + "Sign in to the server to get the list of reports" + '</option>';
					reportNameTD += '</select>';
					reportNameTD += '</div>';
					document.getElementById("reportNameDiv").innerHTML = reportNameTD;
				}
				else {
					var reportNameTD = '';
					var j;
					reportNameTD = '<div>';
					reportNameTD += '<select id="reportNameDDS"  class="f1w4izzo">';
					for (j = 0; j < ReportNameList.length; j++) {
						if (ReportNameList[j] == reportNameInit)
							reportNameTD += ('<option selected>' + ReportNameList[j] + '</option>');
						else
							reportNameTD += ('<option>' + ReportNameList[j] + '</option>');
					}
					reportNameTD += '</select>';
					reportNameTD += '</div>';
					document.getElementById("reportNameDiv").innerHTML = reportNameTD;
				}

				
				let dataOptionTD = '<div>';
				dataOptionTD += '<select id="dataOptionDDS"  class="f1w4izzo">';
				for (let i = 0; i < dataOptions.length; i++) {
					if (dataOptions[i].key === dataOption) {
						dataOptionTD += ('<option selected>' + dataOptions[i].value + '</option>');
					} else {
						dataOptionTD += ('<option>' + dataOptions[i].value + '</option>');
					}
				}
				dataOptionTD += '</select>';
				dataOptionTD += '</div>';
				document.getElementById("dataOptionDiv").innerHTML = dataOptionTD;

				var dataSourceTD = '';
				var k;
				console.log("DataSourceList :", DataSourceList.length);
				let dataSourceArray = dataSourceSheetInit.split(",");
				console.log("dataSourceArray", dataSourceArray);
				dataSourceTD = '<div>';
				dataSourceTD += '<select id="dataSourceSheetDDS"  multiple="multiple" class="f1w4izzo">';
				for (k = 0; k < DataSourceList.length; k++) {
					if (dataSourceArray.includes(DataSourceList[k]))
						dataSourceTD += ('<option selected>' + DataSourceList[k] + '</option>');
					else
						dataSourceTD += ('<option>' + DataSourceList[k] + '</option>');
				}
				dataSourceTD += '</select>';
				dataSourceTD += '</div>';
				document.getElementById("dataSourceDiv").innerHTML = dataSourceTD;

				var ImageSourceTD = '';
				var p;
				let ImageSourceArray = ImageSourceSheetInit.split(",");
				ImageSourceTD = '<div>';
				ImageSourceTD += '<select id="ImageSourceSheetDDS"  multiple="multiple" class="f1w4izzo">';
				for (p = 0; p < ImageSourceList.length; p++) {
					if (ImageSourceArray.includes(ImageSourceList[p]))
						ImageSourceTD += ('<option selected>' + ImageSourceList[p] + '</option>');
					else
						ImageSourceTD += ('<option>' + ImageSourceList[p] + '</option>');
				}
				ImageSourceTD += '</select>';
				ImageSourceTD += '</div>';
				document.getElementById("ImageSourceDiv").innerHTML = ImageSourceTD;

				$('#dataSourceSheetDDS').multiselect();
				$('#ImageSourceSheetDDS').multiselect();

			}


		});
	});


	/**
	 * Stores the selected information in the extension settings,
	 * closes the dialog. 
	 */
	//$('#jarBtn').on('click',function(){console.log("Inside generate Jar function");});

	function generateJar() {
		console.log("Inside generate Jar function");
		const postData = {
			JSONData: sampleData,
			workbookUrl: workbookUrl
		};
		const encodedPostData = encodeData(postData);
		console.log(`Final POST Data: `, postData);
		const postOptions = {
			method: 'POST',
			mode: 'cors',
			headers: {
				'Content-Type': 'application/x-www-form-urlencoded',
				'Content-Length': encodedPostData.length
			},
			body: encodedPostData
		};
		const urlString = urlBase + "?c=generateJar";
		let responseHeaders;
		httpRequest(urlString, postOptions).then(response => {
			responseHeaders = response.headers;
			response.blob().then(blob => {
				console.log(responseHeaders);
				var url = window.URL.createObjectURL(blob);
				var a = document.createElement('a');
				a.href = url;
				a.download = JSON.parse(responseHeaders.get('content-disposition').split("=").pop());
				document.body.appendChild(a); // we need to append the element to the dom -> otherwise it will not work in firefox
				a.click();
				a.remove();  //afterwards we remove the element again     
			}).catch(error => {
				console.log('Error downloading jar file: ', error);
			});
		}).catch(error => {
			console.log('Error generating jar file: ', error);
		});
	}


	function closeDialog() {

		//Get the values selected by users    

		//var  g = document.getElementById ("outputFormatDDS");
		//var outputFormat = g.options[g.selectedIndex].text;

		var outputFormat = $("#outputFormatDDS :selected").text();
		var reportName = $("#reportNameDDS :selected").text();
		const selectedOption = $("#dataOptionDDS :selected").text();
		dataOption = dataOptions.find(item => item.value === selectedOption).key;
		// var dataSourceSheet = $("#dataSourceSheetDDS :selected").text();
		//var ImageSourceSheet = $("#ImageSourceSheetDDS :selected").text();


		var dataSourceSheet1 = [];
		$.each($("#dataSourceSheetDDS :checked"), function () {
			dataSourceSheet1.push($(this).text());
		});
		var dataSourceSheet = dataSourceSheet1.join(",");


		var ImageSourceSheet1 = [];
		$.each($("#ImageSourceSheetDDS :checked"), function () {
			ImageSourceSheet1.push($(this).text());
		});
		var ImageSourceSheet = ImageSourceSheet1.join(",");

		var reportingUrl = $("#reportingUrlDDS :selected").text();
		var reportingApp = $("#reportingAppDDS :selected").text();
		var authentication = $("#authenticationDDS :selected").text();

		console.log('outputFormat : ' + outputFormat);
		console.log('reportName : ' + reportName);
		console.log('dataSourceSheet : ' + dataSourceSheet);
		console.log('ImageSourceSheet : ' + ImageSourceSheet);
		console.log('reportingUrl : ' + reportingUrl);
		console.log('reportingApp : ' + reportingApp);
		console.log('authentication : ' + authentication);
		console.log('Data Option : ' + dataOption);

		var parameterList = [];
		//var parameterMap = {};

		parameterList.push(outputFormat);
		parameterList.push(reportName);
		parameterList.push(dataSourceSheet);
		parameterList.push(ImageSourceSheet);
		parameterList.push(reportingUrl);
		parameterList.push(reportingApp);
		parameterList.push(authentication);
		parameterList.push(dataOption);

		var parameterData = JSON.stringify(parameterList);

		console.log(parameterList);
		console.log(parameterData);

		//var currentSettings = tableau.extensions.settings.getAll();
		//tableau.extensions.settings.set(datasourcesSettingsKey, JSON.stringify(selectedDatasources));

		var currentSettings = tableau.extensions.settings.getAll();
		tableau.extensions.settings.set(parameterListSettingsKey, JSON.stringify(parameterList));

		tableau.extensions.settings.set(outputFormatSettingsKey, JSON.stringify(outputFormat));
		tableau.extensions.settings.set(reportNameSettingsKey, JSON.stringify(reportName));
		tableau.extensions.settings.set(dataSourceSheetSettingsKey, JSON.stringify(dataSourceSheet));
		tableau.extensions.settings.set(ImageSourceSheetSettingsKey, JSON.stringify(ImageSourceSheet));
		tableau.extensions.settings.set(reportingUrlSettingsKey, JSON.stringify(reportingUrl));
		tableau.extensions.settings.set(reportingApplicationSettingsKey, JSON.stringify(reportingApp));
		tableau.extensions.settings.set(authenticationSettingsKey, JSON.stringify(authentication));
		tableau.extensions.settings.set(dataOptionKey, JSON.stringify(dataOption));

		tableau.extensions.settings.saveAsync().then(function (newSavedSettings) {
			tableau.extensions.ui.closeDialog(parameterData);
		});
	}

	/**
	 * Opens or closes the admin area by setting appropriate flags.
	 */
	function toggleAdminArea() {
		adminSectionShown = !adminSectionShown;
		if (adminSectionShown) {
			$('#showHideAdminConfig').removeClass("tb-show-formatting-hints");
			$('#showHideAdminConfig').addClass("tb-hide-formatting-hints");
			$('#showHideAdminConfig').text("Hide admin configuration");
			$('#AdminConfig').removeClass("ng-hide");
			$('#AdminConfig').addClass("ng-show");
		}
		else {
			$('#showHideAdminConfig').text("Show admin configuration");
			$('#showHideAdminConfig').removeClass("tb-hide-formatting-hints");
			$('#showHideAdminConfig').addClass("tb-show-formatting-hints");
			$('#AdminConfig').removeClass("ng-show");
			$('#AdminConfig').addClass("ng-hide");
		}
	}
})();