// deploymentType value will be "Local" for local File Storage System and "AWS_S3" for file storage in S3 bucket
// envType = "local" for developement purposes.
// envType = "prod" for production purposes.

var envType = "prod";

function getHost() {
  if (envType == "local") {
    return "https://" + window.location.hostname + ":9097";
  } else {
    return window.location.origin;
  }
}
function getHostName() {
  if (envType == "local") {
    return "https://" + window.location.hostname + ":3000";
  } else {
    return window.location.origin + "/home/";
  }
}
var Configs = {
  disableServerComponent: false,
  host: getHost(),
  hostName: getHostName(),
  deploymentType: "local",
  outputFileName: "outputFiles",   // FolderName to store Reports Generated in Local Machine 
  emailSignatureImage: getHostName() + "logo.png",
  hideMailComposition: false,
  enableGoogledrive: true,
  defaultEmailBody: "<br><br><br><br><br><figure class='image'><img src='logo.png'></figure><br><b>Report Delivery Agent</b><br>Note: This is an auto generated email. Please do not reply to this email.",
  reportDesignerUrl: getHost() + ":8090/",
  tableauServer: "",
  showSiteList: false
}
