"use strict";

/**
 * UINamespace Sample Extension
 *
 * This sample extension demonstrates how to use the UI namespace
 * to create a popup dialog with additional UI that the user can interact with.
 * The content in this dialog is actually an extension as well (see the
 * uiNamespaceDialog.js for details).
 *
 * This sample is an extension that auto refreshes datasources in the background of
 * a dashboard.  The extension has little need to take up much dashboard space, except
 * when the user needs to adjust settings, so the UI namespace is used for that.
 */


// Add switch to enable/disable console logging
const environment = 'dev'; // Switch to 'prod' to disable logging

// const consoleFn = console.log.bind(null);
// console.log = function (...args){
//   if (environment === 'dev') {
//     consoleFn(...args);
//   }
// }

// Wrap everything in an anonymous function to avoid polluting the global namespace
const defaultIntervalInMin = "5";
let refreshInterval;
let nonEditMode = false;
//let activeDatasourceIdList = [];

//USEReady Begin
//get image base url from imageUrlFile.json
let tableauBaseUrl = "";

// Getting dynamic server, workbook and sitename
let tableauServer = "";
let tableauWorkBook = "";
let siteName = "";
const referrer = document.referrer;
console.log("Referrer",referrer);
let reg;

let dataSourceList = [];
let dataSourceString = "";

let imageSourceList = [];
let imageSourceString = "";

let imageBaseUrlList = [];
//console.log("test :",imageBaseUrlList.length);
let imageBaseUrlString = "";
let imageContentUrlList = [];
let imageContentUrlString = "";
let imageBaseUrl = "";
let contentUrl = "";

let ReportNames = [];
let UserName = "";
let DataSource = "";
let sampleData = "";

let adminConfigurationSaved;
let showAdminTab = true;
let adminTabDisabled = false;
let configIDs;
let sessionToken;
let siteRole;
let userID = "";
let dashbordColumns = [];
let measureNames = [];

let activeDatasourceIdList = [];
let paramData = [];
let paramDataString = "";
let settingsKey = "";

let filterMapForWorksheet = [];

let imageList = "";
let outputFormat = ""; //paramData[0];
let reportName = ""; //paramData[1];
let dataSourceSheet = ""; //paramData[2];
let reportingUrl = "";
let reportingApplication = "";
let authentication = "";
let filterChanged = []; // to store filter names which were changed
let unregisterHandlerFunctions = [];
// urlString = $.validator.format("{0}?ReportName={1}&OutputFormat={2}&ImageList={3}&DataSourceSheet={4}&c=x",[urlBase,reportName,outputFormat,imageList,dataSourceSheet]);

//PPS changes.
let filterData = "";
//USEReady End
$(document).ready(function() {
  tableau.extensions
    .initializeAsync({ configure: preProcessAndConfigure })
    .then(
      function() {
        // First, check for any saved settings and populate our UI based on them.
        //alert(JSON.stringify(tableau.extensions.settings.getAll()));
        checkForSettings(tableau.extensions.settings.getAll());
      },
      function(err) {
        // Something went wrong in initialization
        console.log("Error while Initializing: " + err.toString());
      }
    )
    .then(function() {
      // This event allows for the parent extension and popup extension to keep their
      // settings in sync.  This event will be triggered any time a setting is
      // changed for this extension, in the parent or popup (i.e. when settings.saveAsync is called).
      tableau.extensions.settings.addEventListener(
        tableau.TableauEventType.SettingsChanged,
        settingsEvent => {
          updateExtensionBasedOnSettings(settingsEvent.newSettings);
        }
      );
      fetchFilters();
    });
});

function preProcessAndConfigure() {
  tableau.extensions.dashboardContent.dashboard
    .getParametersAsync()
    .then(params => {
      getParameters(params);
      fetchFilters();
      getDataAndSubmitForm();
    })
    .then(() => {
      nonEditMode = false;
      configure();
    });
}
function absolutePath(base, relative) {
  var stack = base.split("/"),
    parts = relative.split("/");
  stack.pop(); // remove current file name (or empty string)
  // (omit if "base" is the current folder without trailing slash)
  for (var i = 0; i < parts.length; i++) {
    if (parts[i] == ".") continue;
    if (parts[i] == "..") stack.pop();
    else stack.push(parts[i]);
  }
  return stack.join("/");
}
function configure() {
  // This uses the window.location.origin property to retrieve the scheme, hostname, and
  // port where the parent extension is currently running, so this string doesn't have
  // to be updated if the extension is deployed to a new location.
  //const popupUrl = `${window.location.origin}/Samples/ReactTabWebfolio/webfolio.html`;
  fetchFilters();

  //getDataAndSubmitForm();
  const popupUrl = absolutePath(window.location.href, "../index.html");
  /*USEReady Begin*/
  let worksheetArray = [];
  let worksheets = [];
  let dashboardName = "";
  dashboardName = tableau.extensions.dashboardContent.dashboard.name.replace(
    / /g,
    ""
  );
  // console.log("dashboard", dashboardName);
  worksheetArray = tableau.extensions.dashboardContent.dashboard.worksheets;
  //console.log(worksheetArray);
  worksheetArray.forEach(function(worksheet) {
    // console.log(worksheet);
    worksheets.push(worksheet.name);
  });


  try {
    (referrer.search("\/views\/") != -1) ? (reg = /(.*)views\/.*/) : (reg = /(.*)authoring\/.*/);
    let workbook = reg.exec(referrer);
    console.log(workbook);
    if (workbook && workbook[1]) {
      tableauServer = workbook[1];
    }
  } catch (e) {
  console.log("Failed to parse workbook URL");
  }
  console.log("Tableau Server: ", tableauServer);

try {
    (referrer.search("\/views\/") != -1) ? (reg = /.*\/views\/(.*)\/.*/) : (reg = /.*\/authoring\/(.*)\/.*/);
    let workbook = reg.exec(referrer);
    console.log(workbook);
    if (workbook && workbook[1]) {
      tableauWorkBook = workbook[1];
    }
  } catch (e) {
  console.log("Failed to parse workbook URL");
  }
console.log("Workbook: ", tableauWorkBook);

try{
  let isSite = referrer.indexOf("\/t\/");
  let reg1;
  (referrer.search("\/views\/") != -1) ? (reg1 = /.*\/t\/(.*)\/views.*/) : (reg1 = /.*\/t\/(.*)\/authoring.*/);
  if(isSite != -1) 
  {
    let siteArr = [];
    siteArr = reg1.exec(referrer);
    siteName = siteArr[1];
  }
  else
    siteName = "";
  console.log("Site Name: "+ siteName);
}catch (e)	{
  console.log("Failed to parse Site Name ");
}


  let worksheet = worksheetArray[0];
  console.log("Worksheet Name : ",worksheets[0]);

  let options = {
    maxRows: 1, // Max rows to return. Use 0 to return all rows
    ignoreAliases: false,
    ignoreSelection: false,
    includeAllColumns: true
  };

  worksheet.getSummaryDataAsync(options)
    .then(dataTable => {
      console.log("DataTable", dataTable, dataTable.data, dataTable.columns);
      console.log("Worksheet",worksheet.name);
      let data = dataTable.data;
      let field = dataTable.columns;
      let userCol = [{ fieldName: "AsUser" }];
      let userData = reduceToObjects(field, data);

      measureNames = getMeasureNames(userData);
      // console.log("measure names", measureNames);
      // console.log("User Data", userData);

      sampleData = JSON.stringify(userData);
      sampleData = sampleData.substring(1, sampleData.length - 1);
      // console.log("sampleData : " + sampleData);
      UserName = userData[0].AsUser;
      // console.log("User Name : " + UserName);

      // For Fetching all the columns present in the dashboard

      field.shift(); // dataTable Columns
      var columns = field;
      dashbordColumns = [];
      for (var i = 0; i < columns.length; i++) {
        if (
          columns[i]._fieldName != "Measure Names" &&
          columns[i]._fieldName != "Measure Values"
        )
          dashbordColumns.push(columns[i]._fieldName);
      }
      // console.log("DataTable Columns", dashbordColumns);
    }).then(async () => {
      Promise.resolve(getAppliedFilters()).then(res => {
        filterMapForWorksheet = res;
      });

      return(getAppliedFilters());

    })
    .then(async () => {
      var responseJson;
      let savedSettings =
        window.tableau.extensions.settings == undefined
          ? ""
          : window.tableau.extensions.settings.getAll();
      console.log("savedSettings in dasboard : ", savedSettings);

      let dashboardMode = tableau.extensions.environment.mode;
      if (dashboardMode == "authoring") {
        adminTabDisabled = false;
      } else {
        adminTabDisabled = true;
      }

      console.log("AdminTab disable status : ", adminTabDisabled);

      // if (
      //   savedSettings.settingDomain != undefined &&
      //   savedSettings.settingWorkbook != undefined
      // ) {
      if ( tableauServer != undefined &&  tableauWorkBook != undefined  ) {
        adminConfigurationSaved = true;
        

        const response = await fetch(
          window.Configs.host + "/pps/config/user-info",
          {
            method: "POST",
            body: JSON.stringify({
              // server: savedSettings.settingDomain,
              // viewURL: savedSettings.settingWorkbook,
              server: tableauServer,
              viewURL: tableauWorkBook,
              siteName: siteName,
              username: UserName
            }), // string or object
            headers: {
              "Content-Type": "application/json"
            }
          }
        );

        responseJson = await response.json(); //extract JSON from the http response
        console.log(responseJson);
      } else {
        adminConfigurationSaved = false;

        const response = await fetch(
          window.Configs.host + "/pps/config/user-info",
          {
            method: "POST",
            body: JSON.stringify({
              server: "",
              viewURL: "",
              siteName: siteName,
              username: UserName
            }), // string or object
            headers: {
              "Content-Type": "application/json"
            }
          }
        );
        responseJson = await response.json(); //extract JSON from the http response
        console.log(responseJson);
      }

      // do something with myJson

      siteRole = responseJson.siteRole;
      configIDs = responseJson.config_ids;
      userID = responseJson.id;
      sessionToken = responseJson.token;

      console.log("Recent ConfigIds : ", configIDs);

      switch (siteRole) {
        case "ServerAdministrator":
        case "SiteAdministratorCreator":
        case "Creator":
        case "SiteAdministratorExplorer":
          showAdminTab = true;
          break;

        case "Explorer":
        case "ExplorerCanPublish":
          showAdminTab = false;
          break;
        case "Viewer":
        case "Unlicensed":
          showAdminTab = false;
          break;
      }

      console.log("Admin Tab Status", showAdminTab);
      return(responseJson);      
    })
    .then(() => {
      let openPayloadArray = [];
      let openPayloadMap = {};

      openPayloadMap["worksheets"] = JSON.stringify(worksheets);
      openPayloadMap["userName"] = UserName;
      openPayloadMap["filterData"] = "";
      openPayloadMap["paramData"] = $("input[name=ParameterData]").val();
      // openPayloadMap["paramData"] = "";
      openPayloadMap["contentUrl"] = "";
      openPayloadMap["ImageUrlList"] = "";
      openPayloadMap["dashboardName"] = dashboardName;
      openPayloadMap["showAdminTab"] = showAdminTab; //showAdminTab
      openPayloadMap["configIDs"] = configIDs;
      openPayloadMap["sessionToken"] = sessionToken;
      openPayloadMap["adminTabDisabled"] = adminTabDisabled; //adminTabDisabled
      openPayloadMap["dashbordColumns"] = [];
      openPayloadMap["measureNames"] = [];
      openPayloadMap["sheetFilterMap"] = filterMapForWorksheet;

      openPayloadMap["domainName"]= tableauServer;
			openPayloadMap["workbookName"]= tableauWorkBook;
      openPayloadMap["siteName"]= siteName;
      openPayloadMap["siteRole"] = siteRole;


      //pps change end
      openPayloadArray.push(openPayloadMap);
      let openPayloadString = "";
      openPayloadString = JSON.stringify(openPayloadArray);
      console.log("Mapped Filter : " + JSON.stringify(filterMapForWorksheet));

      /*USEReady end*/
      /**
       * This is the API call that actually displays the popup extension to the user.  The
       * popup is always a modal dialog.  The only required parameter is the URL of the popup,
       * which must be the same domain, port, and scheme as the parent extension.
       *
       * The developer can optionally control the initial size of the extension by passing in
       * an object with height and width properties.  The developer can also pass a string as the
       * 'initial' payload to the popup extension.  This payload is made available immediately to
       * the popup extension.  In this example, the value '5' is passed, which will serve as the
       * default interval of refresh.
       */

      // Checking whether the admin Configurations are saved or not
      if (adminConfigurationSaved == false && showAdminTab == false) {
        console.log("Admin Configuration is not saved");
      } else {
        tableau.extensions.ui
          .displayDialogAsync(popupUrl, openPayloadString, {
            height: 600,
            width: 1320
          })
          .then(closePayload => {
            // The promise is resolved when the dialog has been expectedly closed, meaning that
            // the popup extension has called tableau.extensions.ui.closeDialog.
            $("#inactive").hide();
            $("#active").show();

            console.log("ClosePayload : ", JSON.parse(closePayload));
            // The close payload is returned from the popup extension via the closeDialog method.
            // $("#interval").text(closePayload);
            // setupRefreshInterval(closePayload);
          })
          .catch(error => {
            switch (error.errorCode) {
              case tableau.ErrorCodes.DialogClosedByUser:
                console.log("Prev ConfigIds : ", configIDs);
                // location.reload(true);
                console.log("Dialog was closed by user");
                break;
              default:
                console.error(error.message);
            }
            nonEditMode = false;
          });
      }
    });
}

// Filter Mapping to content url
function getAppliedFilters() {
  return new Promise((resolve, reject) => {
    let filterFetchPromises = [];
    let dashboardfilters = [];
    const dashboard = tableau.extensions.dashboardContent.dashboard;

    dashboard.worksheets.forEach(function (worksheet) {
        filterFetchPromises.push(worksheet.getFiltersAsync());
    });

    // Now, we call every filter fetch promise, and wait for all the results
    // to finish before displaying the results to the user.
    Promise.all(filterFetchPromises).then(function (fetchResults) {
      fetchResults.forEach(function (filtersForWorksheet) {
        let sheetFilter = [];
        let sheetName = "";
        let sheetFilterObj ={};
        
        filtersForWorksheet.forEach(function (filter) {
          sheetName = filter.worksheetName;
          let tempFilterObj = formatSheetFilter(filter);
          if(tempFilterObj != null){
            sheetFilter.push(formatSheetFilter(filter));
          }
          
        });
        sheetFilterObj["name"] = sheetName;
        sheetFilterObj["value"] = sheetFilter;
        dashboardfilters.push(sheetFilterObj);
      });

      resolve(dashboardfilters);
    }).catch(err => {
      reject(err);
    });    
  });
}

function formatSheetFilter(filter){
  if (!(filter.fieldName.includes("Measure Names") || filter.fieldName.includes("Action") || filter.fieldName.includes("Metric Type") )){
    let formatSheetFilterValues = {};
    let filterName = filter.fieldName;
    const filterValue = getMappedFilterValues(filter);
    const decodedFilters = decodeURIComponent(filterValue);
    const modifiedFilters = { name: filterName, value: decodedFilters, filterType: filter.filterType, minRange: filter.filterType == "range" ? filter.minValue.formattedValue :"Null", maxRange: filter.filterType == "range" ? filter.maxValue.formattedValue :"Null", isAllSelected: filter.isAllSelected };
    formatSheetFilterValues = modifiedFilters;

    return formatSheetFilterValues;
  }
  return null;
}

function getMappedFilterValues(filter) {
  let filterValues = '';

  switch (filter.filterType) {
    case 'categorical':
      filter.appliedValues.forEach(function (value) {
        filterValues +=encodeURIComponent(value.formattedValue) + ',';
      });
      break;
    case 'range':
      // A range filter can have a min and/or a max.
      if (filter.minValue) {
        filterValues += 'min: ' + filter.minValue.formattedValue + ',';
      }

      if (filter.maxValue) {
        filterValues += 'min: ' + filter.maxValue.formattedValue + ',';
      }
      break;
    case 'relative-date':
      filterValues += 'Period: ' + filter.periodType + ',';
      filterValues += 'RangeN: ' + filter.rangeN + ',';
      filterValues += 'Range Type: ' + filter.rangeType + ',';
      break;
    default:
  }

  // Cut off the trailing ", "
  return filterValues.slice(0, -1);
}

/**
 * This function sets up a JavaScript interval based on the time interval selected
 * by the user.  This interval will refresh all selected datasources.
 */
function setupRefreshInterval(interval) {
  refreshInterval = setInterval(function() {
    let dashboard = tableau.extensions.dashboardContent.dashboard;
    dashboard.worksheets.forEach(function(worksheet) {
      worksheet.getDataSourcesAsync().then(function(datasources) {
        datasources.forEach(function(datasource) {
          if (activeDatasourceIdList.indexOf(datasource.id) >= 0) {
            datasource.refreshAsync();
          }
        });
      });
    });
  }, interval * 60 * 1000);
}

/**
 * Helper that is called to set state anytime the settings are changed.
 */
function updateExtensionBasedOnSettings(settings) {
  if (settings.selectedDatasources) {
    activeDatasourceIdList = JSON.parse(settings.selectedDatasources);
    $("#datasourceCount").text(activeDatasourceIdList.length);
  }
}
//Below functions from pixel-perfect-on-demand
function reduceToObjects(cols, data) {
  let fieldNameMap = $.map(cols, function(col) {
    return col.fieldName;
  });
  let dataToReturn = $.map(data, function(d) {
    return d.reduce(function(memo, value, idx) {
      memo[fieldNameMap[idx]] = value.formattedValue;
      return memo;
    }, {});
  });
  return dataToReturn;
}

function getMeasureNames(data) {
  var unique = {};
  var distinct = [];
  for (var i in data) {
    if (typeof unique[data[i]["Measure Names"]] == "undefined") {
      distinct.push(data[i]["Measure Names"]);
    }
    unique[data[i]["Measure Names"]] = 0;
  }
  console.log("Measure Names", distinct);
  return distinct;
}

function reduceToObjects_v2(cols, data, sheetName) {
  let fieldNameMap = $.map(cols, function(col) {
    return sheetName + "_" + col.fieldName;
  });
  let dataToReturn = $.map(data, function(d) {
    return d.reduce(function(memo, value, idx) {
      memo[fieldNameMap[idx]] = value.formattedValue;
      return memo;
    }, {});
  });
  return dataToReturn;
}

function fetchFilters() {
  // Whenever we restore the filters table, remove all save handling functions,
  // since we add them back later in this function.
  console.log("fetchFilters");
  unregisterHandlerFunctions.forEach(function(unregisterHandlerFunction) {
    unregisterHandlerFunction();
  });

  // Since filter info is attached to the worksheet, we will perform
  // one async call per worksheet to get every filter used in this
  // dashboard.  This demonstrates the use of Promise.all to combine
  // promises together and wait for each of them to resolve.
  let filterFetchPromises = [];

  let dashboardfilters = []; // List of all filters in a dashboard.

  const dashboard = tableau.extensions.dashboardContent.dashboard; // To get filter info, first get the dashboard.

  // Then loop through each worksheet and get its filters, save promise for later.
  dashboard.worksheets.forEach(function(worksheet) {
    filterFetchPromises.push(worksheet.getFiltersAsync());

    // Add filter event to each worksheet.  AddEventListener returns a function that will
    // remove the event listener when called.
    let unregisterHandlerFunction = worksheet.addEventListener(
      tableau.TableauEventType.FilterChanged,
      filterChangedHandler
    );
    unregisterHandlerFunctions.push(unregisterHandlerFunction);
  });
  // Now, we call every filter fetch promise, and wait for all the results
  // to finish before displaying the results to the user.
  Promise.all(filterFetchPromises).then(function(fetchResults) {
    fetchResults.forEach(function(filtersForWorksheet) {
      filtersForWorksheet.forEach(function(filter) {
        dashboardfilters.push(filter);
      });
    });

    //console.log(filterFetchPromises);
    //console.log("Filter Changed:");
    //tconsole.log(dashboardfilters);
    //console.log("dashboard filters:"+JSON.stringify(dashboardfilters));
    filterChanged = dashboardfilters;
  });
}
function filterChangedHandler(filterEvent) {
  // Just reconstruct the filters table whenever a filter changes.
  // This could be optimized to add/remove only the different filters.
  fetchFilters();
}

function checkForSettings(settings) {
  // console.log("settings:"+JSON.stringify(settings));
  if (Object.keys(settings).length > 0) {
    //TODO: Add Code here to save the image

    // outputFormat = JSON.parse(settings.outputFormat);
    // reportName = JSON.parse(settings.reportName);
    //dataSourceSheet = JSON.parse(settings.dataSourceSheet);
    // reportingUrl = JSON.parse(settings.reportingUrl);
    // reportingApplication = JSON.parse(settings.reportingApplication);
    // authentication = JSON.parse(settings.authentication);
    // paramData = JSON.parse(settings.selectedParameters);
    //console.log("hitesh paramData:"+settings.selectedParameters);
    // paramDataString = settings.selectedParameters;
    settingsKey = settings.settingsKey;

    let correctedKeyValues =
      settingsKey !== undefined ? settingsKey.trim() : ""; //remove initial whitespaces
    console.log(correctedKeyValues);
    var keys = correctedKeyValues.split(",");
    var k = new Array();
    for (var i = 0; i < keys.length; i++) {
      if (keys[i] != undefined) {
        k.push(keys[i]);
      }
    }
    settingsKey = k.join(",");

    //console.log(outputFormat,reportName,dataSourceSheet,reportingUrl,reportingApplication,authentication);

    /*    if (outputFormat == "PDF") {
        document.getElementById("ReportButton").src = "pdf.svg";
      } else if (outputFormat == "HTML") {
        document.getElementById("ReportButton").src = "html.svg";
      } else if (outputFormat == "XLSX" || outputFormat == "XLS") {
        document.getElementById("ReportButton").src = "xls.svg";
      } else if (outputFormat == "DOCX" || outputFormat == "DOC") {
        document.getElementById("ReportButton").src = "doc.svg";
      } else if (outputFormat == "PPT" || outputFormat == "PPTX") {
        document.getElementById("ReportButton").src = "ppt.svg";
      }

      $("#inactive").hide();
      $("#active").show();
      */
  }
}
//modified some
function getDataAndSubmitForm() {
  //console.log("Inside getDataAndSubmitForm()");
  //console.log("imageBaseUrl : " + imageBaseUrl);

  dataSourceList = [];
  dataSourceString = "";

  imageSourceList = [];
  imageSourceString = "";

  imageBaseUrlList = [];
  imageBaseUrlString = "";
  imageContentUrlList = [];
  imageContentUrlString = "";

  //event.preventDefault();
  //Set vars now.
  //hitesh: commented below line
  //urlString = $.validator.format("{0}?ReportName={1}&OutputFormat={2}&ImageList={3}&DataSourceSheet={4}&c=x",[urlBase,reportName,outputFormat,imageList,dataSourceSheet]);
  //console.log(urlString);

  //Pixel Perfect Server, no need of urlString
  //$("#PostForm").attr("action",urlString);

  //Code to get date time stamp
  const monthNames = [
    "January",
    "February",
    "March",
    "April",
    "May",
    "June",
    "July",
    "August",
    "September",
    "October",
    "November",
    "December"
  ];

  let now = new Date();
  let monthName = monthNames[now.getMonth()];

  let timeStamp =
    monthName +
    " " +
    now.getDate() +
    " " +
    now.getFullYear() +
    ", " +
    now.getHours() +
    ":" +
    now.getMinutes() +
    ":" +
    now.getSeconds();
  //let timeStamp = new Date().toLocaleString();
  console.log("timeStamp : " + timeStamp);
  //$('input[name=timeStamp]').val(timeStamp);

  let con_url_test1 = document.getElementById("contentUrl");
  console.log("con_url_test before: " + con_url_test1.value);

  //Get data source to pull data from
  //let DataSource = dataSourceSheet;

  //DataSource = dataSourceSheet;
  //if(typeof DataSource !== 'undefined'){console.log("DataSource : "+DataSource);}
  //else{console.log('DataSource Parameter Not Found');}

  //findFilter();

  //fetchFilters();//TODO: added for debugging; remove later

  //const dashboard = tableau.extensions.dashboardContent.dashboard;

  var dashboardName =
    tableauWorkBook +
    "/sheets/" +
    tableau.extensions.dashboardContent.dashboard.name.replace(/ /g, "");

  console.log("filterChanged:" + filterChanged);
  for (let filter in filterChanged) {
    console.log("name:" + filterChanged[filter].fieldName);
  }
  getFilterValues(filterChanged);

  $("input[name=contentUrl]").val(dashboardName);
  //Pixel Perfect Server moving to configure
  //findParameter();

  //$('input[name=UserName]').val(UserName);

  if (dataSourceList.length > 0) {
    let DataSource0 = dataSourceList[0];
    const dashboard = tableau.extensions.dashboardContent.dashboard; //get dashboard
    //console.log(dashboard._dashboardImpl._info.name); //dashboard name

    //PPS commenting below Async method
    const worksheets = tableau.extensions.dashboardContent.dashboard.worksheets;
    let worksheet0 = worksheets.find(function(sheet) {
      //console.log("Sheet Name: "+sheet.name);
      return sheet.name === DataSource0;
    });
    //getting user name
    let options0 = {
      maxRows: 1, // Max rows to return. Use 0 to return all rows
      ignoreAliases: false,
      ignoreSelection: false,
      includeAllColumns: true
    };
    worksheet0.getSummaryDataAsync(options0).then(dataTable => {
      let data = dataTable.data;
      let field = dataTable.columns;
      let userData = reduceToObjects(field, data);
      UserName = userData[0].AsUser;
      $("input[name=UserName]").val(UserName);
      console.log("User Name : " + UserName);
    });
  } else {
    $("input[name=UserName]").val("username");
  }

  if (dataSourceList.length > 0) {
    // get underlying data
    let options = {
      maxRows: 0, // Max rows to return. Use 0 to return all rows
      ignoreAliases: false,
      ignoreSelection: false,
      includeAllColumns: true
    };

    let DataList = [];
    let DataMap = {};
    let finalData = "";
    let iteratecount = 0;
    let value = 0;
    for (value in dataSourceList) {
      (function() {
        console.log("Inside for loop function. Value : " + value);
        let DataSource = dataSourceList[value];
        const worksheets =
          tableau.extensions.dashboardContent.dashboard.worksheets;
        let worksheet = worksheets.find(function(sheet) {
          //console.log("Sheet Name: "+sheet.name);
          return sheet.name === DataSource;
        });
        worksheet.getSummmaryDataAsync(options).then(dataTable => {
          let data = dataTable.data;
          let dataCount = data.length;
          //console.log("Data Count : "+dataCount);
          //let formattedValue = data[0][0].formattedValue;
          let sheetName = dataSourceList[iteratecount];
          let field = dataTable.columns;
          let fieldCount = field.length;
          let field2 = [];
          let fieldMap = {};
          for (let i in field) {
            fieldMap["fieldName"] = field[i]["fieldName"].replace(
              /[&\/\\#,+()$~%.'":*?<>{} ]/g,
              "_"
            );
            field2.push(fieldMap);
            fieldMap = {};
            console.log(field2[i]["fieldName"]);
          }
          let underlyingData = reduceToObjects_v2(field2, data, sheetName); //userCol->field
          //UserName = underlyingData[0].AsUser;
          //console.log("User Name : " + UserName);
          //$('input[name=UserName]').val(UserName);
          let JSONData = JSON.stringify(underlyingData);
          DataMap["Worksheet"] = JSONData;
          console.log(
            "DataMap " + iteratecount + " : " + JSON.stringify(DataMap)
          );
          DataList.push(DataMap);
          //console.log("DataList : " + DataList);
          DataMap = {};
          iteratecount = iteratecount + 1;
          //console.log("Selected Data : "+JSONData);
          console.log("JSON String Length : " + JSONData.length);
          console.log("Data Count : " + dataCount);

          if (iteratecount == dataSourceList.length) {
            console.log("Inside Final Function");
            //console.log("DataList : " + DataList);

            finalData += "[";
            for (let i = 0; i < iteratecount; i++) {
              console.log(DataList[i].Worksheet);
              finalData += DataList[i].Worksheet.substring(
                1,
                DataList[i].Worksheet.length - 1
              );
              finalData += ",";
            }
            finalData = finalData.substring(0, finalData.length - 1);
            finalData += "]";
            console.log("finalData : " + finalData);

            $("input[name=JSONData]").val(finalData);
            //pps commenting below line.
            //$("#PostForm").submit();		//Submit the form.
          }

          //$('input[name=JSONData]').val(JSONData);
          //$("#PostForm").submit();		//Submit the form.
        });
      })(value);

      //console.log("DataList Before : " + DataList);
    }
  } else {
    $("input[name=JSONData]").val("[]");
    //pps commenting below line
    //$("#PostForm").submit();		//Submit the form.
  }

  //console.log("DataList After :" + DataList);
  //$('input[name=JSONData]').val(JSONData);
  //$("#PostForm").submit();		//Submit the form.
}

function getFilterValues(filterdata) {
  let filterList2 = [];
  let filterMap = {};

  let fList = []; // To get the filters in FilterName: Value1,Value2 format
  let fMap = {};

  console.log("filterData:" + filterData);
  console.log("filterData:" + filterdata);

  let uniqueFiltersList = [];
  for (let filter in filterdata) {
    if (filterdata[filter].fieldName !== "Measure Names") {
      // && !(filterdata[filter].fieldName.startsWith("Action (")))
      if (
        filterdata[filter].filterType == "categorical" &&
        filterdata[filter].appliedValues.length > 0
      ) {
        fMap["FilterName"] = filterdata[filter].fieldName;
        fMap["FilterValues"] = JSON.stringify(filterdata[filter].appliedValues);
        fMap["FilterType"] = filterdata[filter].filterType;
        fList.push(fMap);
        fMap = {};

        for (let value in filterdata[filter].appliedValues) {
          filterMap["name"] = filterdata[filter].fieldName;
          filterMap["filterType"] = filterdata[filter].filterType;
          filterMap["value"] =
            filterdata[filter].appliedValues[value].formattedValue;
          filterMap["minRange"] = "Null";
          filterMap["maxRange"] = "Null";
          filterList2.push(filterMap);
          filterMap = {};
          //console.log(filterdata[filter].fieldName);
          //console.log(filterdata[filter].appliedValues[value].formattedValue);
        }

        if (filterdata[filter].fieldName == "DataSourceSheet") {
          let value = 0;
          for (value in filterdata[filter].appliedValues) {
            dataSourceList.push(
              filterdata[filter].appliedValues[value].formattedValue
            );
            dataSourceString +=
              filterdata[filter].appliedValues[value].formattedValue;

            if (value + 1 != filterdata[filter].appliedValues.length) {
              dataSourceString += ",";
            }
          }
        }
        //filterdata[filter].fieldName == "ImageSourceSheet"
        //Rishabh to check the below code for populating the ImageUrl
        let value = 0;
        for (value in filterdata[filter].appliedValues) {
          imageSourceList.push(
            filterdata[filter].appliedValues[value].formattedValue
          );
          imageSourceString +=
            filterdata[filter].appliedValues[value].formattedValue;

          if (value + 1 != filterdata[filter].appliedValues.length) {
            imageSourceString += ",";
          }
        }
      } else if (filterdata[filter].filterType == "range") {
        let fRange = [];
        fRange = [
          filterdata[filter]._min._formattedValue,
          filterdata[filter]._max._formattedValue
        ];
        fMap["FilterName"] = filterdata[filter].fieldName;
        fMap["FilterValues"] = JSON.stringify(fRange);
        fMap["FilterType"] = filterdata[filter].filterType;
        fList.push(fMap);
        fMap = {};

        filterMap["name"] = filterdata[filter].fieldName;
        filterMap["filterType"] = filterdata[filter].filterType;
        filterMap["value"] = "Null";
        filterMap["minRange"] = filterdata[filter]._min._formattedValue; // Min Range
        filterMap["maxRange"] = filterdata[filter]._max._formattedValue; // Max Range
        filterList2.push(filterMap);
        filterMap = {};
      }
    }
  }

  let worksheetArray = [];
  let worksheets = [];
  worksheetArray = tableau.extensions.dashboardContent.dashboard.worksheets;
  //console.log(worksheetArray);
  worksheetArray.forEach(function(worksheet) {
    worksheets.push(worksheet.name);
  });
  let val = 0;
  for (val in worksheets) {
    let str = worksheets[val];
    var res = str.split(" ");
    var updatedSheetName = "";
    for (var i in res) {
      updatedSheetName += res[i];
    }
    console.log(updatedSheetName);
    imageBaseUrlList.push(
      tableauBaseUrl +
        "views/" +
        tableauWorkBook +
        "/" +
        updatedSheetName +
        ".png"
    );
    // imageBaseUrlString +=  tableauBaseUrl+"views/"+tableauWorkBook+"/"+updatedSheetName+".png";
  }
  console.log(imageBaseUrlList);
  let value = 0;
  for (value in imageSourceList) {
    imageContentUrlList.push(
      tableauWorkBook + "/sheets/" + imageSourceList[value]
    );
    imageContentUrlString +=
      tableauWorkBook + "/sheets/" + imageSourceList[value];

    if (value + 1 != imageSourceList.length) {
      imageBaseUrlString += ";";
      imageContentUrlString += ";";
    }
  }

  console.log("imageBaseUrlString : " + imageBaseUrlList);
  console.log("ContentUrlList : " + imageContentUrlList);

  let newArray = [];
  let lookupObject = {};
  for (let i in fList) {
    lookupObject[fList[i]["FilterName"]] = fList[i];
  }
  for (let i in lookupObject) {
    newArray.push(lookupObject[i]);
  }

  uniqueFiltersList = newArray;
  //console.log("uniqueFiltersList : " + JSON.stringify(uniqueFiltersList));

  //code to get 2nd half of image url
  //TODO: add code to handle range or quantitative filter
  let imageUrlSecondHalf = "";
  for (let j in uniqueFiltersList) {
    //Code for getting filter names
    let tempFilterName = uniqueFiltersList[j].FilterName;
    if (tempFilterName.startsWith("Action (")) {
      let strA = tempFilterName.replace("Action (", "");
      let strB = strA.replace(")", "");
      //imageUrlSecondHalf += strB + "=";
      //Code for getting filter values
      if (uniqueFiltersList[j].FilterType == "categorical") {
        if (j != 0) {
          imageUrlSecondHalf += "&";
        }
        //imageUrlSecondHalf += "vf_" + strB + "=";
        imageUrlSecondHalf += strB + "=";
        let tempValueList = [];
        tempValueList = JSON.parse(uniqueFiltersList[j].FilterValues);
        for (let k in tempValueList) {
          if (k != 0) {
            imageUrlSecondHalf += ",";
          }
          imageUrlSecondHalf += tempValueList[k]._value; // + ",";
        }
        //imageUrlSecondHalf += "&";
      }
    } else {
      //imageUrlSecondHalf += tempFilterName + "=";
      //Code for getting filter values
      if (uniqueFiltersList[j].FilterType == "categorical") {
        if (j != 0) {
          imageUrlSecondHalf += "&";
        }
        //imageUrlSecondHalf += "vf_" + tempFilterName + "=";
        imageUrlSecondHalf += tempFilterName + "=";
        let tempValueList = [];
        tempValueList = JSON.parse(uniqueFiltersList[j].FilterValues);
        for (let k in tempValueList) {
          if (k != 0) {
            imageUrlSecondHalf += ",";
          }
          imageUrlSecondHalf += tempValueList[k]._value; // + ",";
        }
        //imageUrlSecondHalf += "&";
      }
    }
  }
  //console.log(imageUrlSecondHalf);
  /*
      let imgUrl = "";
      imgUrl = imageBaseUrl + "?" + imageUrlSecondHalf.replace(/ /g, "%20");
      console.log("Image URL 1 : " + imgUrl);
      $('input[name=ImageUrlList]').val(imgUrl); 
      
      let imgUrl2 = "";
      imgUrl2 = imageBaseUrlList[1] + "?" + imageUrlSecondHalf.replace(/ /g, "%20"); //TODO: remove hardcoded values
      console.log("Image URL 2 : " + imgUrl2);
      $('input[name=ImageUrlList2]').val(imgUrl2);
      */

  let finalImageUrl = [];
  if (imageBaseUrlList.length != 0) {
    for (let cnt = 0; cnt < imageBaseUrlList.length; cnt++) {
      //finalImageUrl += imageBaseUrlList[cnt] + "?" + imageUrlSecondHalf.replace(/ /g, "%20");
      finalImageUrl.push(
        imageBaseUrlList[cnt] + "?" + imageUrlSecondHalf.replace(/ /g, "%20")
      );
      //if (cnt+1 < imageBaseUrlList.length){finalImageUrl+=";";}
    }
  }
  console.log(finalImageUrl);
  let imageURL = finalImageUrl[0].replace(
    "/views/SaleMap",
    ""
  );
  $("input[name=ImageUrlList]").val(imageURL);

  //console.log(filterList2);
  let FilterData = JSON.stringify(filterList2);
  //console.log("Filter Data:");
  //console.log(FilterData);
  //alert(FilterData);

  $("input[name=FilterData]").val(FilterData);
}

function findParameter() {
  tableau.extensions.dashboardContent.dashboard
    .getParametersAsync()
    .then(params => {
      getParameters(params);
    });
}
function getParameters(paramList) {
  let parameterList2 = [];
  let parameterMap = {};

  for (let param in paramList) {
    parameterMap["name"] = paramList[param].name;
    parameterMap["value"] = paramList[param].currentValue.formattedValue;
    if(parameterMap["name"] != "Count or Amount 7"){
      parameterList2.push(parameterMap);
    }
    parameterMap = {};
  }
  //console.log(parameterList2);
  let ParameterData = JSON.stringify(parameterList2);
  console.log("Parameter Data:");
  console.log(ParameterData);
  $("input[name=ParameterData]").val(ParameterData);
}

function openDialog() {
  nonEditMode = true;
  console.log("clicked on extensions");
  preProcessAndConfigure();
}
