--
-- ppradminQL database dump
--

-- Dumped from database version 12.2
-- Dumped by pg_dump version 12.2

-- Started on 2020-11-22 18:53:35

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 2917 (class 1262 OID 16741)
-- Name: pixelperfect; Type: DATABASE; Schema: -; Owner: ppradmin
--

CREATE DATABASE pixelperfect WITH TEMPLATE = template0 ENCODING = 'UTF8';


ALTER DATABASE pixelperfect OWNER TO ppradmin;

\connect pixelperfect

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 6 (class 2615 OID 16742)
-- Name: ppserver; Type: SCHEMA; Schema: -; Owner: ppradmin
--

CREATE SCHEMA ppserver;


ALTER SCHEMA ppserver OWNER TO ppradmin;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 203 (class 1259 OID 16743)
-- Name: configure_table; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.configure_table (
    config_id integer NOT NULL,
    username character varying(300) NOT NULL,
    as_user character varying(300) NOT NULL,
    password character varying(1000) NOT NULL,
    server character varying(1000) NOT NULL,
    api_version character varying(1000) NOT NULL,
    filter_data character varying(10485760) NOT NULL,
    parameter_data character varying(10485760) NOT NULL,
    image_data character varying(10485760) NOT NULL,
    frequency character varying(10485760) NOT NULL,
    view_content_url character varying(10485760) NOT NULL,
    report_name character varying(10485760) NOT NULL,
    export_type integer NOT NULL,
    created_date timestamp with time zone DEFAULT CURRENT_TIMESTAMP,
    updated_date timestamp with time zone DEFAULT CURRENT_TIMESTAMP,
    data_source character varying(2048) NOT NULL,
    start_time timestamp with time zone NOT NULL,
    end_time timestamp with time zone,
    sch_interval bigint,
    permission integer,
    status integer DEFAULT 0,
    folder_id bigint DEFAULT 0,
    is_export smallint,
    mail_id integer,
    selected_columns character varying(10485760),
    site_name character varying(10485760) COLLATE pg_catalog."C",
    client_offset character varying(10485760) COLLATE pg_catalog."C",
    available_parameter_data character varying(10485760),
    max_runs bigint,
    runs bigint,
    schedule_data character varying(10485760),
    transpose_data boolean,
    sftp_enabled boolean
);


ALTER TABLE ppserver.configure_table OWNER TO ppradmin;

--
-- TOC entry 2918 (class 0 OID 0)
-- Dependencies: 203
-- Name: COLUMN configure_table.status; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.configure_table.status IS 'Config 1- pause, -1- delete';


--
-- TOC entry 2919 (class 0 OID 0)
-- Dependencies: 203
-- Name: COLUMN configure_table.folder_id; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.configure_table.folder_id IS 'report folder selection 0-default location,some other id refer to ';


--
-- TOC entry 2920 (class 0 OID 0)
-- Dependencies: 203
-- Name: COLUMN configure_table.is_export; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.configure_table.is_export IS '0 - no action ,1 - send generated report status, 2 - send generated report as attachment';


--
-- TOC entry 2921 (class 0 OID 0)
-- Dependencies: 203
-- Name: COLUMN configure_table.mail_id; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.configure_table.mail_id IS 'reger to mail table id';


--
-- TOC entry 2922 (class 0 OID 0)
-- Dependencies: 203
-- Name: COLUMN configure_table.selected_columns; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.configure_table.selected_columns IS 'Selected columns of the dashboard data by user for generating report';


--
-- TOC entry 204 (class 1259 OID 16755)
-- Name: configure_table_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

CREATE SEQUENCE ppserver.configure_table_config_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ppserver.configure_table_config_id_seq OWNER TO ppradmin;

--
-- TOC entry 2923 (class 0 OID 0)
-- Dependencies: 204
-- Name: configure_table_config_id_seq; Type: SEQUENCE OWNED BY; Schema: ppserver; Owner: ppradmin
--

ALTER SEQUENCE ppserver.configure_table_config_id_seq OWNED BY ppserver.configure_table.config_id;


--
-- TOC entry 205 (class 1259 OID 16757)
-- Name: folder_table; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.folder_table (
    folder_id bigint NOT NULL,
    create_user character varying(10485760) NOT NULL,
    folder_name character varying(10485760) NOT NULL,
    parent_folder_id bigint DEFAULT 0,
    created_date timestamp with time zone DEFAULT CURRENT_TIMESTAMP,
    updated_date timestamp with time zone DEFAULT CURRENT_TIMESTAMP,
    status bigint DEFAULT 0,
    folder_path character varying(10485760)
);


ALTER TABLE ppserver.folder_table OWNER TO ppradmin;

--
-- TOC entry 2924 (class 0 OID 0)
-- Dependencies: 205
-- Name: COLUMN folder_table.status; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.folder_table.status IS 'folder active delete status 0-active -1-delete';


--
-- TOC entry 2925 (class 0 OID 0)
-- Dependencies: 205
-- Name: COLUMN folder_table.folder_path; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.folder_table.folder_path IS 'folder stroage path';


--
-- TOC entry 206 (class 1259 OID 16767)
-- Name: folder_table_folder_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

CREATE SEQUENCE ppserver.folder_table_folder_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ppserver.folder_table_folder_id_seq OWNER TO ppradmin;

--
-- TOC entry 2926 (class 0 OID 0)
-- Dependencies: 206
-- Name: folder_table_folder_id_seq; Type: SEQUENCE OWNED BY; Schema: ppserver; Owner: ppradmin
--

ALTER SEQUENCE ppserver.folder_table_folder_id_seq OWNED BY ppserver.folder_table.folder_id;


--
-- TOC entry 207 (class 1259 OID 16769)
-- Name: gen_report; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.gen_report (
    gen_report_id bigint NOT NULL,
    config_id integer NOT NULL,
    job_id integer NOT NULL,
    gen_report_name character varying(256) NOT NULL,
    created_date timestamp without time zone DEFAULT CURRENT_TIMESTAMP,
    status bigint DEFAULT 0,
    folder_id bigint DEFAULT 0,
    report_path character varying(10485760)
);


ALTER TABLE ppserver.gen_report OWNER TO ppradmin;

--
-- TOC entry 2927 (class 0 OID 0)
-- Dependencies: 207
-- Name: COLUMN gen_report.status; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.gen_report.status IS 'report present status 0-present, -1-deleted';


--
-- TOC entry 2928 (class 0 OID 0)
-- Dependencies: 207
-- Name: COLUMN gen_report.folder_id; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.gen_report.folder_id IS 'report folder selection 0-default location,some other id refer to folder id';


--
-- TOC entry 2929 (class 0 OID 0)
-- Dependencies: 207
-- Name: COLUMN gen_report.report_path; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.gen_report.report_path IS 'report path storage';


--
-- TOC entry 208 (class 1259 OID 16778)
-- Name: gen_report_gen_report_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

CREATE SEQUENCE ppserver.gen_report_gen_report_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ppserver.gen_report_gen_report_id_seq OWNER TO ppradmin;

--
-- TOC entry 2930 (class 0 OID 0)
-- Dependencies: 208
-- Name: gen_report_gen_report_id_seq; Type: SEQUENCE OWNED BY; Schema: ppserver; Owner: ppradmin
--

ALTER SEQUENCE ppserver.gen_report_gen_report_id_seq OWNED BY ppserver.gen_report.gen_report_id;


--
-- TOC entry 209 (class 1259 OID 16780)
-- Name: job_table; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.job_table (
    job_id integer NOT NULL,
    config_id integer NOT NULL,
    status integer NOT NULL,
    report_engine_name character varying(1000) NOT NULL,
    created_date timestamp with time zone DEFAULT CURRENT_TIMESTAMP,
    updated_date timestamp with time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE ppserver.job_table OWNER TO ppradmin;

--
-- TOC entry 210 (class 1259 OID 16788)
-- Name: job_table_job_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

CREATE SEQUENCE ppserver.job_table_job_id_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ppserver.job_table_job_id_seq OWNER TO ppradmin;

--
-- TOC entry 2931 (class 0 OID 0)
-- Dependencies: 210
-- Name: job_table_job_id_seq; Type: SEQUENCE OWNED BY; Schema: ppserver; Owner: ppradmin
--

ALTER SEQUENCE ppserver.job_table_job_id_seq OWNED BY ppserver.job_table.job_id;


--
-- TOC entry 211 (class 1259 OID 16790)
-- Name: mail_table; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.mail_table (
    mail_id bigint NOT NULL,
    create_user character varying(10485760) NOT NULL,
    to_address character varying(10485760) NOT NULL,
    subject character varying(10485760),
    body character varying(10485760),
    attachments character varying(10485760),
    created_date timestamp with time zone DEFAULT CURRENT_TIMESTAMP,
    updated_date timestamp with time zone DEFAULT CURRENT_TIMESTAMP
);


ALTER TABLE ppserver.mail_table OWNER TO ppradmin;

--
-- TOC entry 2932 (class 0 OID 0)
-- Dependencies: 211
-- Name: COLUMN mail_table.mail_id; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.mail_table.mail_id IS 'Table primary key mail_table';


--
-- TOC entry 2933 (class 0 OID 0)
-- Dependencies: 211
-- Name: COLUMN mail_table.create_user; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.mail_table.create_user IS 'Create User ID';


--
-- TOC entry 2934 (class 0 OID 0)
-- Dependencies: 211
-- Name: COLUMN mail_table.to_address; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.mail_table.to_address IS 'to address in comma seperated';


--
-- TOC entry 2935 (class 0 OID 0)
-- Dependencies: 211
-- Name: COLUMN mail_table.subject; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.mail_table.subject IS 'subject of mail';


--
-- TOC entry 2936 (class 0 OID 0)
-- Dependencies: 211
-- Name: COLUMN mail_table.body; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.mail_table.body IS 'body of mail';


--
-- TOC entry 2937 (class 0 OID 0)
-- Dependencies: 211
-- Name: COLUMN mail_table.attachments; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON COLUMN ppserver.mail_table.attachments IS 'Generated Report ID in comma seperated';


--
-- TOC entry 212 (class 1259 OID 16798)
-- Name: mail_table_mail_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

CREATE SEQUENCE ppserver.mail_table_mail_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ppserver.mail_table_mail_id_seq OWNER TO ppradmin;

--
-- TOC entry 2938 (class 0 OID 0)
-- Dependencies: 212
-- Name: mail_table_mail_id_seq; Type: SEQUENCE OWNED BY; Schema: ppserver; Owner: ppradmin
--

ALTER SEQUENCE ppserver.mail_table_mail_id_seq OWNED BY ppserver.mail_table.mail_id;


--
-- TOC entry 214 (class 1259 OID 16830)
-- Name: report_config; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.report_config (
    config_id integer NOT NULL,
    view_content_url character varying(10485760),
    image_data character varying(10485760),
    data_source character varying(10485760),
    export_types character varying(10485760),
    report_name character varying(10485760),
    config_name character varying(10485760),
    created_by character varying(10485760),
    modified_by character varying(10485760),
    created_at timestamp without time zone,
    modified_at timestamp without time zone,
    transpose_data boolean,
    selected_columns character varying(10485760),
    site_name character varying(10485760)
);


ALTER TABLE ppserver.report_config OWNER TO ppradmin;

--
-- TOC entry 2939 (class 0 OID 0)
-- Dependencies: 214
-- Name: TABLE report_config; Type: COMMENT; Schema: ppserver; Owner: ppradmin
--

COMMENT ON TABLE ppserver.report_config IS 'Table to store report configuration details  eg. - Workbook name, Data sheets, Image sheets, Exportable formats etc';


--
-- TOC entry 213 (class 1259 OID 16828)
-- Name: report_config_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.report_config ALTER COLUMN config_id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.report_config_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- TOC entry 220 (class 1259 OID 16917)
-- Name: sftp_config; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.sftp_config (
    site_name character varying(10485760),
    username character varying(10485760),
    password character varying(10485760),
    folder character varying(10485760),
    created_by character varying(10485760),
    created_at timestamp without time zone,
    modified_by character varying(10485760),
    modified_at timestamp without time zone
);


ALTER TABLE ppserver.sftp_config OWNER TO ppradmin;

--
-- TOC entry 216 (class 1259 OID 16840)
-- Name: sites; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.sites (
    id bigint NOT NULL,
    name character varying(10485760) NOT NULL,
    content_url character varying(10485760) NOT NULL,
    tableau_id character varying(10485760) NOT NULL,
    template_id character varying(10485760),
    created_date timestamp without time zone,
    updated_date timestamp without time zone,
    created_by character varying,
    updated_by character varying
);


ALTER TABLE ppserver.sites OWNER TO ppradmin;

--
-- TOC entry 215 (class 1259 OID 16838)
-- Name: sites_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.sites ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.sites_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    MAXVALUE 10485760
    CACHE 1
);


--
-- TOC entry 217 (class 1259 OID 16873)
-- Name: template_sequence; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

CREATE SEQUENCE ppserver.template_sequence
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ppserver.template_sequence OWNER TO ppradmin;

--
-- TOC entry 219 (class 1259 OID 16898)
-- Name: templates; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.templates (
    id bigint NOT NULL,
    name character varying NOT NULL
);


ALTER TABLE ppserver.templates OWNER TO ppradmin;

--
-- TOC entry 218 (class 1259 OID 16896)
-- Name: templates_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.templates ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.templates_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- TOC entry 2749 (class 2604 OID 16800)
-- Name: configure_table config_id; Type: DEFAULT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.configure_table ALTER COLUMN config_id SET DEFAULT nextval('ppserver.configure_table_config_id_seq'::regclass);


--
-- TOC entry 2754 (class 2604 OID 16801)
-- Name: folder_table folder_id; Type: DEFAULT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.folder_table ALTER COLUMN folder_id SET DEFAULT nextval('ppserver.folder_table_folder_id_seq'::regclass);


--
-- TOC entry 2758 (class 2604 OID 16802)
-- Name: gen_report gen_report_id; Type: DEFAULT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.gen_report ALTER COLUMN gen_report_id SET DEFAULT nextval('ppserver.gen_report_gen_report_id_seq'::regclass);


--
-- TOC entry 2761 (class 2604 OID 16803)
-- Name: job_table job_id; Type: DEFAULT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.job_table ALTER COLUMN job_id SET DEFAULT nextval('ppserver.job_table_job_id_seq'::regclass);


--
-- TOC entry 2764 (class 2604 OID 16804)
-- Name: mail_table mail_id; Type: DEFAULT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.mail_table ALTER COLUMN mail_id SET DEFAULT nextval('ppserver.mail_table_mail_id_seq'::regclass);


--
-- TOC entry 2766 (class 2606 OID 16754)
-- Name: configure_table configure_table_pkey; Type: CONSTRAINT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.configure_table
    ADD CONSTRAINT configure_table_pkey PRIMARY KEY (config_id);


--
-- TOC entry 2768 (class 2606 OID 16806)
-- Name: folder_table folder_table_pkey; Type: CONSTRAINT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.folder_table
    ADD CONSTRAINT folder_table_pkey PRIMARY KEY (folder_id);


--
-- TOC entry 2770 (class 2606 OID 16808)
-- Name: gen_report gen_report_pkey; Type: CONSTRAINT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.gen_report
    ADD CONSTRAINT gen_report_pkey PRIMARY KEY (gen_report_id);


--
-- TOC entry 2772 (class 2606 OID 16810)
-- Name: job_table job_table_pkey; Type: CONSTRAINT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.job_table
    ADD CONSTRAINT job_table_pkey PRIMARY KEY (job_id);


--
-- TOC entry 2774 (class 2606 OID 16812)
-- Name: mail_table mail_table_pkey; Type: CONSTRAINT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.mail_table
    ADD CONSTRAINT mail_table_pkey PRIMARY KEY (mail_id);


--
-- TOC entry 2776 (class 2606 OID 16837)
-- Name: report_config report_config_pkey; Type: CONSTRAINT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.report_config
    ADD CONSTRAINT report_config_pkey PRIMARY KEY (config_id);


--
-- TOC entry 2779 (class 2606 OID 16847)
-- Name: sites sites_pkey; Type: CONSTRAINT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.sites
    ADD CONSTRAINT sites_pkey PRIMARY KEY (id);


--
-- TOC entry 2782 (class 2606 OID 16905)
-- Name: templates templates_pkey; Type: CONSTRAINT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.templates
    ADD CONSTRAINT templates_pkey PRIMARY KEY (id, name);


--
-- TOC entry 2777 (class 1259 OID 16863)
-- Name: content_url_idx; Type: INDEX; Schema: ppserver; Owner: ppradmin
--

CREATE UNIQUE INDEX content_url_idx ON ppserver.sites USING btree (content_url);


--
-- TOC entry 2780 (class 1259 OID 16906)
-- Name: template_name_idx; Type: INDEX; Schema: ppserver; Owner: ppradmin
--

CREATE UNIQUE INDEX template_name_idx ON ppserver.templates USING btree (name);


--
-- TOC entry 2783 (class 2606 OID 16813)
-- Name: gen_report gen_report_config_id_fkey; Type: FK CONSTRAINT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.gen_report
    ADD CONSTRAINT gen_report_config_id_fkey FOREIGN KEY (config_id) REFERENCES ppserver.configure_table(config_id) ON DELETE CASCADE;


--
-- TOC entry 2784 (class 2606 OID 16818)
-- Name: gen_report gen_report_job_id_fkey; Type: FK CONSTRAINT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.gen_report
    ADD CONSTRAINT gen_report_job_id_fkey FOREIGN KEY (job_id) REFERENCES ppserver.job_table(job_id) ON DELETE CASCADE;


--
-- TOC entry 2785 (class 2606 OID 16823)
-- Name: job_table job_table_config_id_fkey; Type: FK CONSTRAINT; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ONLY ppserver.job_table
    ADD CONSTRAINT job_table_config_id_fkey FOREIGN KEY (config_id) REFERENCES ppserver.configure_table(config_id) ON DELETE CASCADE;


-- Completed on 2020-11-22 18:53:35

--
-- ppradminQL database dump complete
--
CREATE TABLE ppserver.service_url_config (
    id bigint NOT NULL,
    url character varying,
    status boolean DEFAULT true,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying
);


ALTER TABLE ppserver.service_url_config OWNER TO ppradmin;

--
-- TOC entry 228 (class 1259 OID 74226)
-- Name: service_url_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.service_url_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.service_url_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- TOC entry 233 (class 1259 OID 74254)
-- Name: sftp_config_master; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.sftp_config_master (
    id bigint NOT NULL,
    host character varying NOT NULL,
    port character varying,
    admin_user character varying NOT NULL,
    sftp_endpoint character varying NOT NULL,
    jwt_token_endpoint character varying,
    admin_token character varying,
    push_sftp_flag character varying,
    path_placeholder character varying,
    status boolean,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying
);


ALTER TABLE ppserver.sftp_config_master OWNER TO ppradmin;

--
-- TOC entry 234 (class 1259 OID 74260)
-- Name: sftp_config_master_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.sftp_config_master ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.sftp_config_master_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);

CREATE TABLE ppserver.smtp_config (
    id bigint NOT NULL,
    mail_password character varying NOT NULL,
    mail_from character varying NOT NULL,
    mail_host character varying NOT NULL,
    mail_port character varying NOT NULL,
    mail_type character varying NOT NULL,
    file_max_size bigint,
    status boolean DEFAULT true,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying,
    mail_secure boolean,
    username character varying
);


ALTER TABLE ppserver.smtp_config OWNER TO ppradmin;

--
-- TOC entry 232 (class 1259 OID 74245)
-- Name: smtp_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.smtp_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.smtp_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- TOC entry 229 (class 1259 OID 74228)
-- Name: ssl_config; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.ssl_config (
    id bigint NOT NULL,
    key_file character varying,
    certificate_file character varying,
    key_passphrase character varying,
    chain_file character varying,
	keystore_flag boolean DEFAULT false,
    ssl_enabled boolean NOT NULL,
    status boolean DEFAULT true,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying,
    keystore_file character varying,
    key_store_password character varying,
	keystore_type character varying ,
	key_alias character varying
);


ALTER TABLE ppserver.ssl_config OWNER TO ppradmin;

--
-- TOC entry 230 (class 1259 OID 74234)
-- Name: ssl_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.ssl_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.ssl_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- TOC entry 235 (class 1259 OID 74262)
-- Name: storage_config; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.storage_config (
    id bigint NOT NULL,
    environment_type character varying NOT NULL,
    status boolean,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying,
    report_output_path character varying,
    reports_bucket_path character varying,
    templates_bucket_path character varying,
    templates_path character varying
);


ALTER TABLE ppserver.storage_config OWNER TO ppradmin;

--
-- TOC entry 236 (class 1259 OID 74268)
-- Name: storage_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.storage_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.storage_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);


--
-- TOC entry 225 (class 1259 OID 65930)
-- Name: tableau_config; Type: TABLE; Schema: ppserver; Owner: ppradmin
--

CREATE TABLE ppserver.tableau_config (
    id bigint NOT NULL,
    server character varying NOT NULL,
	name character varying ,
    api_version character varying,
    username character varying NOT NULL,
    password character varying NOT NULL,
    status boolean DEFAULT true,
    created_at timestamp with time zone,
    created_by character varying,
    modified_at timestamp with time zone,
    modified_by character varying
);


ALTER TABLE ppserver.tableau_config OWNER TO ppradmin;

--
-- TOC entry 226 (class 1259 OID 65933)
-- Name: tableau_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.tableau_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
    SEQUENCE NAME ppserver.tableau_config_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1
);

CREATE TABLE ppserver.services_config (
    id bigint NOT NULL,
	service_display_name character varying,
	service_name character varying,
	service_description character varying,
	service_endpoint character varying,
	status boolean DEFAULT true,
	created_at timestamp with time zone,
	created_by character varying,
	modified_at timestamp with time zone,
	modified_by character varying
);


ALTER TABLE ppserver.services_config OWNER TO ppradmin;
--
-- TOC entry 228 (class 1259 OID 74226)
-- Name: services_config_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.services_config ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
	SEQUENCE NAME ppserver.services_config_id_seq
	START WITH 1
	INCREMENT BY 1
	NO MINVALUE
	NO MAXVALUE
	CACHE 1
);

CREATE TABLE ppserver.alerts (
	id bigint NOT NULL,
	severity character varying,
	description character varying,
	service_api character varying,
	status boolean DEFAULT true,
	created_at timestamp without time zone,
	created_by character varying,
	modified_at timestamp without time zone,
	modified_by character varying
);


ALTER TABLE ppserver.alerts OWNER TO ppradmin;

--
-- TOC entry 228 (class 1259 OID 74226)
-- Name: alerts_id_seq; Type: SEQUENCE; Schema: ppserver; Owner: ppradmin
--

ALTER TABLE ppserver.alerts ALTER COLUMN id ADD GENERATED ALWAYS AS IDENTITY (
	SEQUENCE NAME ppserver.alerts_id_seq
	START WITH 1
	INCREMENT BY 1
	NO MINVALUE
	NO MAXVALUE
	CACHE 1
);

CREATE USER repmgr SUPERUSER REPLICATION;

create database repmgr with owner repmgr;

