#!/bin/bash
# Pixel Perfect Node Installation
SRC_DIR=$(pwd)
DEST_DIR=/opt/pixelperfect
echo "You have selected Node Installation"
filepath=/opt/bootstrap.json
# Fetch hostname, ipaddress, ack_api_path, service_ids (where enabled is set to true)
PRIMARY_HOSTNAME=$(cat $filepath | jq -r ".primaryServer")
PRIMARY_IPADDRESS=$(cat $filepath | jq -r ".primaryIpAddress") 
ACK_PATH=$(cat $filepath | jq -r ".acknowledgementUrl")
# IDS=$(cat "$filepath" | jq -r '.services | map(select(.enabled == true)) | .[].id')
# SERVICE_IDS=($IDS)
SERVICE_IDS=$(cat $filepath | jq -r '.services[] | select(.enabled == true) | .id' | paste -sd "," -)
ACK_URL=$PRIMARY_HOSTNAME":9096"$ACK_PATH
IS_PRIMARY="false"

# Replace localhost with primary node hostname for  spring.datasource.url in application.properties of all the micreservices

sed -i "s|spring.datasource.url=jdbc:postgresql://localhost:|spring.datasource.url=jdbc:postgresql://$PRIMARY_IPADDRESS:|g" "$DEST_DIR"/pixelperfect_server/pixel_perfect_clustercontroller/application.properties
sed -i "s|spring.datasource.url=jdbc:postgresql://localhost:|spring.datasource.url=jdbc:postgresql://$PRIMARY_IPADDRESS:|g" "$DEST_DIR"/pixelperfect_server/pixel_perfect_configuration/application.properties
sed -i "s|spring.datasource.url=jdbc:postgresql://localhost:|spring.datasource.url=jdbc:postgresql://$PRIMARY_IPADDRESS:|g" "$DEST_DIR"/pixelperfect_server/pixel_perfect_api/application.properties 
sed -i "s|spring.datasource.url=jdbc:postgresql://localhost:|spring.datasource.url=jdbc:postgresql://$PRIMARY_IPADDRESS:|g" "$DEST_DIR"/pixelperfect_server/pixel_perfect_engine/application.properties
sed -i "s|spring.datasource.url=jdbc:postgresql://localhost:|spring.datasource.url=jdbc:postgresql://$PRIMARY_IPADDRESS:|g" "$DEST_DIR"/pixelperfect_server/pixel_perfect_scheduler/application.properties
 
# JDK installation
sudo mkdir -p /opt/pixelperfect/output_files
#sudo cp -r java-se-8u41-ri "$DEST_DIR"
JAVA_HOME="$DEST_DIR"/java-se-8u41-ri
export JAVA_HOME=$JAVA_HOME
echo "export JAVA_HOME=${JAVA_HOME}" | sudo tee /etc/profile.d/openjdk.sh
echo "export JRE_HOME=${JAVA_HOME}/jre" | sudo tee -a /etc/profile.d/openjdk.sh
echo "export PATH=$PATH:${JAVA_HOME}/bin" | sudo tee -a /etc/profile.d/openjdk.sh
source /etc/profile
java -version
sudo ln -s /usr/lib64/libreadline.so.7 /usr/lib64/libreadline.so.6
sudo ln -s "$DEST_DIR"/pgsql/lib/libpq.so.5 /usr/lib64/libpq.so.5
# Create ppradmin user and ppr directory
sudo useradd ppradmin -d "$DEST_DIR" -s /bin/bash
sudo echo Useready1 | passwd ppradmin --stdin
#echo "Enter password for ppradmin user: "
#sudo passwd ppradmin
sudo chown -R ppradmin:ppradmin "$DEST_DIR"
sudo usermod -a -G ppradmin $USER

# ppradmin installation
#sudo cp -r pgsql "$DEST_DIR"
sudo chown -R ppradmin:ppradmin "$DEST_DIR"
echo "export PATH=$PATH:${DEST_DIR}/pgsql/bin" | sudo tee /etc/profile.d/postgresql_ppr.sh
source /etc/profile
#read -rsp "Enter ppradmin user password: " PPRADMIN_PASSWORD
PPRADMIN_PASSWORD=Useready1
sudo echo "$PPRADMIN_PASSWORD" | sudo tee "$DEST_DIR"/pgsql/bin/.pgpass
sudo runuser -u ppradmin -- "$DEST_DIR"/pgsql/bin/initdb -D "$DEST_DIR"/pgsql/data
sudo cp "$DEST_DIR"/services/postgresql_ppr.service /etc/systemd/system
sudo systemctl daemon-reload
sudo systemctl start postgresql_ppr
#sudo systemctl status postgresql_ppr


# Call the configuration script
#sudo cp -r pixelperfect_server "$DEST_DIR"
#sudo cp "$SRC_DIR"/*.sh "$DEST_DIR"
sudo cp "$DEST_DIR"/services/*.service /etc/systemd/system

#Copy BirtOnline Files 

# sudo cp /Y "$DEST_DIR"/pixelperfect_server/birtonline/lib64/* /usr/lib64  add ldlIB
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/etc/* /etc
if [ -d "/etc/fonts" ]
then
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/etc_fonts/* /etc/fonts
else
    sudo mkdir /etc/fonts
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/etc_fonts/* /etc/fonts
fi
if [ -d "/etc/xdg" ] 
then
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/etc_xdg/* /etc/xdg 
else
    sudo mkdir /etc/xdg
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/etc_xdg/* /etc/xdg
fi
if [ -d "/usr/share/bash-completion/completions" ] 
then
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_share_bash-completion_completions/* /usr/share/bash-completion/completions 
else
    sudo mkdir /usr/share/bash-completion/completions
    sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_share_bash-completion_completions/* /usr/share/bash-completion/completions
fi        

sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/locale/xkeyboard-config.7.gz /usr/share/man/man7/
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/locale/xkeyboard-config.mo /usr/share/locale/en_GB/LC_MESSAGES/
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_bin/* /usr/bin 
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_share/* /usr/share
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_share_themes/* /usr/share/themes
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/usr_share_icons/* /usr/share/icons
sudo cp -R -n "$DEST_DIR"/pixelperfect_server/birtonline/libs/lib64/gdk-pixbuf-2.0 /usr/lib64


sudo cp -n "$DEST_DIR"/pixelperfect_server/birtonline/apps/python/local_bin/localbin.tar /usr/local/bin
sudo cp -n "$DEST_DIR"/pixelperfect_server/birtonline/apps/python/local_lib/locallib.tar /usr/local/lib
sudo tar -xvf /usr/local/lib/locallib.tar --directory /usr/local/lib
sudo tar -xvf /usr/local/bin/localbin.tar --directory /usr/local/bin
sudo tar -xvf /usr/share/icons/Adwaita.tar --directory /usr/share/icons

sudo cp -R -n "$DEST_DIR"/utils/net-sf-jpam /etc/pam.d 

echo "export PATH=$PATH:${DEST_DIR}/pixelperfect_server/birtonline/libs/usr_bin:/usr/local/bin" | sudo tee -a /etc/profile.d/ppr.sh
source /etc/profile

sudo echo "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/pixelperfect/pixelperfect_server/birtonline/libs/lib64/" | sudo tee -a /etc/profile.d/pprbirt.sh
source /etc/profile


#sudo cp ./*.class "$DEST_DIR"
#sudo cp ./*.jar "$DEST_DIR"
#cd "$DEST_DIR" || exit
sudo chown -R ppradmin:ppradmin "$DEST_DIR"
#./configure_credentials.sh auto

sudo chown -R ppradmin:ppradmin "$DEST_DIR"

sudo systemctl daemon-reload
sudo runuser -u ppradmin -- "$DEST_DIR"/pgsql/bin/psql -U ppradmin -p 8032 -d postgres -a -f "$DEST_DIR"/pixelperfect_server/schema/schema.sql
sudo runuser -u ppradmin -- "$DEST_DIR"/pgsql/bin/psql -U ppradmin -p 8032 -d pixelperfect -a -f "$DEST_DIR"/pixelperfect_server/schema/storage_insert.sql
sudo systemctl start pixel_perfect_clustercontroller pixel_perfect_configuration

sudo rm -rf /usr/local/lib/locallib.tar
sudo rm -rf /usr/local/bin/localbin.tar


{ echo "alias ppr-start='sudo systemctl start pixel_perfect_clustercontroller pixel_perfect_configuration pixel_perfect_api pixel_perfect_engine pixel_perfect_scheduler'";
echo "alias ppr-stop='sudo systemctl stop pixel_perfect_clustercontroller pixel_perfect_configuration pixel_perfect_api pixel_perfect_engine pixel_perfect_scheduler'";
echo "alias ppr-restart='sudo systemctl restart pixel_perfect_clustercontroller pixel_perfect_configuration pixel_perfect_api pixel_perfect_engine pixel_perfect_scheduler'";
echo "alias ppr-status='sudo systemctl status pixel_perfect_clustercontroller pixel_perfect_configuration pixel_perfect_api pixel_perfect_engine pixel_perfect_scheduler'"; 
echo "alias show-logs='tail -f ${DEST_DIR}/pixelperfect_server/pixel_perfect_api/spring.log ${DEST_DIR}/pixelperfect_server/pixel_perfect_engine/spring.log ${DEST_DIR}/pixelperfect_server/pixel_perfect_scheduler/spring.log'"; } >>~/.bashrc
source ~/.bashrc

# Make the rep_configuration file executable
chmod +x "$DEST_DIR"/scripts/rep_configuration.sh

sudo tar -xvf "$DEST_DIR"/pixelperfect_server/birtonline/apps/birt.tar --directory "$DEST_DIR"/pixelperfect_server/birtonline/apps/
# sudo rm -rf "$DEST_DIR"/pixelperfect_server/birtonline/apps/birt.tar

host_names=$(cat $filepath | jq -r ".nodeDetails[].hostName")
HOST_USERNAME=ppradmin
HOST_PASSWORD=Useready1
if [ -f /opt/pixelperfect/.ssh/id_rsa.pub ]; then
    echo "id_rsa.pub FILE EXISTS"
    # Copying key to all the nodes given in the bootstrap file
    for host_name in $host_names; do
        echo ${host_name}
        COPY_SSH_COMMAND="sshpass -p ${HOST_PASSWORD} ssh-copy-id -i /opt/pixelperfect/.ssh/id_rsa.pub -o StrictHostKeyChecking=no ${HOST_USERNAME}@${host_name}"
        echo $COPY_SSH_COMMAND
        sudo chown -R ppradmin:ppradmin "$DEST_DIR"
        su -s /bin/bash -c "$COPY_SSH_COMMAND" ppradmin
    done
    # Copy key ALL NODES.. DONE
else
    echo "id_rsa.pub FILE DOES NOT EXISTS"
    mkdir -p /opt/pixelperfect/.ssh
    sudo chown -R ppradmin:ppradmin "$DEST_DIR"
    GENERATE_SSH_COMMAND="ssh-keygen -q -t rsa -N '' -f /opt/pixelperfect/.ssh/id_rsa <<<y >/dev/null 2>&1"
    echo $GENERATE_SSH_COMMAND
    su -s /bin/bash -c "$GENERATE_SSH_COMMAND" ppradmin
    sudo chown -R ppradmin:ppradmin "$DEST_DIR"
    echo "key generated"
    # Copying key to all the nodes given in the bootstrap file
    for host_name in $host_names; do
        echo ${host_name}
        COPY_SSH_COMMAND="sshpass -p ${HOST_PASSWORD} ssh-copy-id -i /opt/pixelperfect/.ssh/id_rsa.pub -o StrictHostKeyChecking=no ${HOST_USERNAME}@${host_name}"
        echo $COPY_SSH_COMMAND
        sudo chown -R ppradmin:ppradmin "$DEST_DIR"
        su -s /bin/bash -c "$COPY_SSH_COMMAND" ppradmin
    done
    # Copy key ALL NODES.. DONE
fi

echo $PRIMARY_HOSTNAME
echo $PRIMARY_IPADDRESS
echo $ACK_PATH
echo $ACK_URL
echo ${SERVICE_IDS}
# Get hostname and private IP address (excluding loopback address)
MY_HOSTNAME=$(hostname)
MY_IP=$(ip addr show | grep -w inet | grep -v 127.0.0.1 | awk '{ print $2 }' | awk -F '/' '{ print $1 }')
# Send an acknowledgement api call to the primary node
echo "{\"hostName\":\"${MY_HOSTNAME}\",\"hostIp\":\"${MY_IP}\",\"serviceId\":\"${SERVICE_IDS}\",\"primaryServer\":\"false\",\"newServer\":\"true\",\"hostAlreadyAdded\":\"false\" }"
ACK_RESPONSE=$(curl --header "Content-Type: application/json" --request POST --data "{\"hostName\":\"${MY_HOSTNAME}\",\"hostIp\":\"${MY_IP}\",\"serviceId\":\"${SERVICE_IDS}\",\"primaryServer\":\"false\",\"newServer\":\"true\",\"hostAlreadyAdded\":\"false\" }"  ${ACK_URL})
echo ${ACK_RESPONSE}

echo "Installation complete"
